% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{SetAssayData}
\alias{SetAssayData}
\alias{SetAssayData.Assay}
\alias{SetAssayData.Seurat}
\title{Setter for multimodal data}
\usage{
SetAssayData(object, ...)

\method{SetAssayData}{Assay}(object, slot, new.data, ...)

\method{SetAssayData}{Seurat}(object, slot = "data", new.data, assay = NULL, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{slot}{Where to store the new data}

\item{new.data}{New data to insert}

\item{assay}{Name of assay whose data should be set}
}
\value{
object with the assay data set
}
\description{
Setter for multimodal data
}
\examples{
# Set an Assay slot directly
count.data <- GetAssayData(object = pbmc_small[["RNA"]], slot = "counts")
count.data <- as.matrix(x = count.data + 1)
new.assay <- SetAssayData(object = pbmc_small[["RNA"]], slot = "counts", new.data = count.data)

# Set an Assay slot through the Seurat object
count.data <- GetAssayData(object = pbmc_small[["RNA"]], slot = "counts")
count.data <- as.matrix(x = count.data + 1)
new.seurat.object <- SetAssayData(
    object = pbmc_small,
    slot = "counts",
    new.data = count.data,
    assay = "RNA"
)

}
