% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\docType{methods}
\name{stack}
\alias{stack}
\alias{stack,Satellite-method}
\title{Convert selected layers of a Satellite object to a RasterStack}
\usage{
\S4method{stack}{Satellite}(x, layer = names(x), ...)
}
\arguments{
\item{x}{an object of class 'Satellite'}

\item{layer}{character vector (bcde codes) or integer vector (index) of 
the layers to be stacked}

\item{...}{additional arguments passed on to \code{\link{stack}}}
}
\description{
Convert selected layers of a Satellite object to a RasterStack
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

stck <- stack(sat, c("B001n", "B002n", "B003n"))
stck

}
