% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_split.R
\name{initial_split}
\alias{initial_split}
\alias{initial_time_split}
\alias{training}
\alias{testing}
\title{Simple Training/Test Set Splitting}
\usage{
initial_split(data, prop = 3/4, strata = NULL, breaks = 4, ...)

initial_time_split(data, prop = 3/4, ...)

training(x)

testing(x)
}
\arguments{
\item{data}{A data frame.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{strata}{A variable that is used to conduct stratified sampling to
create the resamples. This could be a single character value or a variable
name that corresponds to a variable that exists in the data frame.}

\item{breaks}{A single number giving the number of bins desired to stratify
a numeric stratification variable.}

\item{...}{Not currently used.}

\item{x}{An \code{rsplit} object produced by \code{initial_split}}
}
\value{
An \code{rset} object that can be used with the \code{training} and \code{testing}
functions to extract the data in each split.
}
\description{
\code{initial_split} creates a single binary split of the data into a training
set and testing set. \code{initial_time_split} does the same, but takes the
\emph{first} \code{prop} samples for training, instead of a random selection.
\code{training} and \code{testing} are used to extract the resulting data.
}
\details{
The \code{strata} argument causes the random sampling to be conducted
\emph{within the stratification variable}. The can help ensure that the number of
data points in the training data is equivalent to the proportions in the
original data set.
}
\examples{
set.seed(1353)
car_split <- initial_split(mtcars)
train_data <- training(car_split)
test_data <- testing(car_split)

drinks_split <- initial_time_split(drinks)
train_data <- training(drinks_split)
test_data <- testing(car_split)
c(max(train_data$date), min(test_data$date))  # no overlap
}
