% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_utilities.R
\name{utilitiesForSurvivalTrials}
\alias{utilitiesForSurvivalTrials}
\alias{getLambdaByPi}
\alias{getLambdaByMedian}
\alias{getHazardRatioByPi}
\alias{getPiByLambda}
\alias{getPiByMedian}
\alias{getMedianByLambda}
\alias{getMedianByPi}
\title{Survival Helper Functions for Conversion of Pi, Lambda, Median}
\usage{
getLambdaByPi(piValue, eventTime = C_EVENT_TIME_DEFAULT, kappa = 1)

getLambdaByMedian(median, kappa = 1)

getHazardRatioByPi(pi1, pi2, eventTime = C_EVENT_TIME_DEFAULT, kappa = 1)

getPiByLambda(lambda, eventTime = C_EVENT_TIME_DEFAULT, kappa = 1)

getPiByMedian(median, eventTime = C_EVENT_TIME_DEFAULT, kappa = 1)

getMedianByLambda(lambda, kappa = 1)

getMedianByPi(piValue, eventTime = C_EVENT_TIME_DEFAULT, kappa = 1)
}
\arguments{
\item{piValue, pi1, pi2, lambda, median}{Value that shall be converted.}

\item{eventTime}{The assumed time under which the event rates 
are calculated, default is \code{12}.}

\item{kappa}{The scale parameter of the Weibull distribution, default is \code{1}. 
The Weibull distribution cannot be used for the piecewise
   definition of the survival time distribution.}
}
\description{
Functions to convert pi, lambda and median values into each other.
}
\details{
Can be used, e.g., to convert median values into pi or lambda values for usage in
\code{\link{getSampleSizeSurvival}} or \code{\link{getPowerSurvival}}.
}
