% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{new_quosures}
\alias{new_quosures}
\alias{as_quosures}
\alias{is_quosures}
\title{Create a list of quosures}
\usage{
new_quosures(x)

as_quosures(x, env, named = FALSE)

is_quosures(x)
}
\arguments{
\item{x}{A list of quosures or objects to coerce to quosures.}

\item{env}{The default environment for the new quosures.}

\item{named}{Whether to name the list with \code{\link[=quos_auto_name]{quos_auto_name()}}.}
}
\description{
This small S3 class provides methods for \code{[} and \code{c()} and ensures
the following invariants:
\itemize{
\item The list only contains quosures.
\item It is always named, possibly with a vector of empty strings.
}

\code{new_quosures()} takes a list of quosures and adds the \code{quosures}
class and a vector of empty names if needed. \code{as_quosures()} calls
\code{\link[=as_quosure]{as_quosure()}} on all elements before creating the \code{quosures}
object.
}
