% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{setEnvironment}
\alias{setEnvironment}
\title{Set Environment}
\usage{
setEnvironment(envir)
}
\arguments{
\item{envir}{Environment to be used as outer environment.}
}
\description{
Defines the outer environment of the app. Outer environment is a parent for all session environments.
It is used to store variables that are common for all the client sessions. The only way to make changes outside of
the outer environment is to use the global assignment operator \code{<<-} if and only if changes are 
made to the variable that does not exist in the outer environment.
}
\details{
By default, an environment where app was initialized (via \code{\link{openPage}} function or with \code{App$new()} call)
is used.

This function is a wrapper around \code{setEnvironment} method of class \code{\link{App}}.
}
\examples{
\donttest{
openPage()
e <- new.env()
setEnvironment(e)

sendCommand("jrc.sendData('x', 10)", wait = 3)
print(e$x)
closePage()
}

}
