% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{surround}
\alias{surround}
\title{Set borders for a selection of cells}
\usage{
surround(
  x,
  i = NULL,
  j = NULL,
  border = NULL,
  border.top = NULL,
  border.bottom = NULL,
  border.left = NULL,
  border.right = NULL,
  part = "body"
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{border}{border (shortcut for top, bottom, left and right)}

\item{border.top}{border top}

\item{border.bottom}{border bottom}

\item{border.left}{border left}

\item{border.right}{border right}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
Highlight specific cells with borders.

To set borders for the whole table, use \code{\link[=border_outer]{border_outer()}},
\code{\link[=border_inner_h]{border_inner_h()}} and \code{\link[=border_inner_v]{border_inner_v()}}.

All the following functions also support the
row and column selector \code{i} and \code{j}:
\itemize{
\item \code{\link[=hline]{hline()}}: set bottom borders (inner horizontal)
\item \code{\link[=vline]{vline()}}: set right borders (inner vertical)
\item \code{\link[=hline_top]{hline_top()}}: set the top border (outer horizontal)
\item \code{\link[=vline_left]{vline_left()}}: set the left border (outer vertical)
}
}
\examples{
library(officer)
library(flextable)

# cell to highlight
vary_i <- 1:3
vary_j <- 1:3

std_border <- fp_border(color = "orange")

ft <- flextable(head(iris))
ft <- border_remove(x = ft)
ft <- border_outer(x = ft, border = std_border)

for (id in seq_along(vary_i)) {
  ft <- bg(
    x = ft,
    i = vary_i[id],
    j = vary_j[id], bg = "yellow"
  )
  ft <- surround(
    x = ft,
    i = vary_i[id],
    j = vary_j[id],
    border.left = std_border,
    border.right = std_border,
    part = "body"
  )
}

ft <- autofit(ft)
ft
# # render
# print(ft, preview = "pptx")
# print(ft, preview = "docx")
# print(ft, preview = "pdf")
# print(ft, preview = "html")
}
\seealso{
Other borders management: 
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_inner}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline_bottom}()},
\code{\link{hline_top}()},
\code{\link{hline}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()},
\code{\link{vline}()}
}
\concept{borders management}
