% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rayleigh-distribution.R
\name{Rayleigh}
\alias{Rayleigh}
\alias{drayleigh}
\alias{prayleigh}
\alias{qrayleigh}
\alias{rrayleigh}
\title{Rayleigh distribution}
\usage{
drayleigh(x, sigma = 1, log = FALSE)

prayleigh(q, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qrayleigh(p, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rrayleigh(n, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{sigma}{positive valued parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Rayleigh distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{x}{\sigma^2} \exp\left(-\frac{x^2}{2\sigma^2}\right)
}{
f(x) = x/\sigma^2 * exp(-(x^2 / 2*\sigma^2))
}

Cumulative distribution function
\deqn{
F(x) = 1 - \exp\left(-\frac{x^2}{2\sigma^2}\right)
}{
F(x) = 1 - exp(-x^2 / 2*\sigma^2)
}

Quantile function
\deqn{
F^{-1}(p) = \sqrt{-2\sigma^2 \log(1-p)}
}{
F^-1(p) = sqrt(-2*\sigma^2 * log(1-p))
}
}
\examples{

x <- rrayleigh(1e5, 13)
hist(x, 100, freq = FALSE)
curve(drayleigh(x, 13), 0, 60, col = "red", add = TRUE)
hist(prayleigh(x, 13)) 
plot(ecdf(x))
curve(prayleigh(x, 13), 0, 60, col = "red", lwd = 2, add = TRUE) 

}
\references{
Krishnamoorthy, K. (2006). Handbook of Statistical Distributions
with Applications. Chapman & Hall/CRC.

Forbes, C., Evans, M. Hastings, N., & Peacock, B. (2011).
Statistical Distributions. John Wiley & Sons.
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
