% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year-month-day-count-between}
\alias{year-month-day-count-between}
\alias{calendar_count_between.clock_year_month_day}
\title{Counting: year-month-day}
\usage{
\method{calendar_count_between}{clock_year_month_day}(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[clock_year_month_day]}

A pair of year-month-day vectors. These will be recycled to their
common size.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
\item \code{"month"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
This is a year-month-day method for the \code{\link[=calendar_count_between]{calendar_count_between()}} generic.
It counts the number of \code{precision} units between \code{start} and \code{end}
(i.e., the number of years or months).
}
\details{
\code{"quarter"} is equivalent to \code{"month"} precision with \code{n} set to \code{n * 3L}.
}
\examples{
# Compute an individual's age in years
x <- year_month_day(2001, 2, 4)
today <- year_month_day(2021, 11, 30)
calendar_count_between(x, today, "year")

# Compute the number of months between two dates, taking
# into account the day of the month and time of day
x <- year_month_day(2000, 4, 2, 5)
y <- year_month_day(2000, 7, c(1, 2, 2), c(3, 4, 6))
calendar_count_between(x, y, "month")
}
