% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-false.R
\name{chk_false}
\alias{chk_false}
\alias{vld_false}
\title{Check FALSE}
\usage{
chk_false(x, x_name = NULL)

vld_false(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Check if FALSE using

\code{is.logical(x) && length(x) == 1L && !anyNA(x) && !x}
}
\section{Functions}{
\itemize{
\item \code{vld_false()}: Validate FALSE

}}
\examples{
# chk_false
chk_false(FALSE)
try(chk_false(0))
# vld_false
vld_false(TRUE)
vld_false(FALSE)
vld_false(NA)
vld_false(0)
vld_false(c(FALSE, FALSE))
}
\seealso{
\code{\link[=is.logical]{is.logical()}}

\code{\link[=length]{length()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other logical_checkers: 
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_logical}()},
\code{\link{chk_true}()}

Other scalar_checkers: 
\code{\link{chk_count}()},
\code{\link{chk_date}()},
\code{\link{chk_date_time}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_true}()},
\code{\link{chk_tz}()}
}
\concept{logical_checkers}
\concept{scalar_checkers}
