% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.aln.R
\name{community.aln}
\alias{community.aln}
\title{Align communities from two or more networks}
\usage{
community.aln(x, ..., aln = NULL)
}
\arguments{
\item{x, ...}{two or more objects of class \code{cna} (if the numbers of
nodes are different, an alignment \sQuote{fasta} object is required for 
the \code{aln} argument; See below) as obtained from function \code{\link{cna}}. 
Alternatively, a list of \code{cna} objects can be given to \code{x}.}

\item{aln}{alignment for comparing networks with different numbers of nodes.}
}
\value{
Returns a list of updated \code{cna} objects.
}
\description{
Find equivalent communities from two or more networks and re-assign colors
to them in a consistent way across networks. A \sQuote{new.membership} vector is
also generated for each network, which maps nodes to community IDs that are 
renumbered according to the community equivalency.
}
\details{
This function facilitates the inspection on the variance of the community
partition in a group of similar networks. The original community numbering
(and so the colors of communities in the output of \code{plot.cna} and 
\code{vmd.cna}) can be inconsistent across networks, i.e. equivalent 
communities may display different colors, impeding network comparison. 
The function calculates the dissimilarity between all communities and 
clusters communities with \sQuote{hclust} funciton. In each cluster, 0 or
1 community per network is included. The color attribute of communities is 
then re-assigned according to the clusters through all networks. In addition,
a \sQuote{new.membership} vector is generated for each network, which mapps 
nodes to new community IDs that are numbered consistently across networks.
}
\examples{
\donttest{
  # Needs MUSCLE installed - testing excluded
  if(check.utility("muscle")) {

    if (!requireNamespace("igraph", quietly = TRUE)) {
      message('Need igraph installed to run this example')
    } else {

    ## Fetch PDB files and split to chain A only PDB files
    ids <- c("1tnd_A", "1tag_A")
    files <- get.pdb(ids, split = TRUE, path = tempdir())
    
    ## Sequence Alignement
    pdbs <- pdbaln(files, outfile = tempfile())
    
    ## Normal mode analysis on aligned data
    modes <- nma(pdbs, rm.gaps=TRUE)
    
    ## Dynamic Cross Correlation Matrix
    cijs <- dccm(modes)$all.dccm
 
    ## Correlation Network
    nets <- cna(cijs, cutoff.cij=0.3)

    ## Align network communities
    nets.aln <- community.aln(nets)

    ## plot all-residue and coarse-grained (community) networks
    pdb <- pdbs2pdb(pdbs, inds=1, rm.gaps=TRUE)[[1]]
    op <- par(no.readonly=TRUE)

    # before alignment
    par(mar=c(0.1, 0.1, 0.1, 0.1), mfrow=c(2,2))
    invisible( lapply(nets, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3, full=TRUE)[, 1:2], 
               full=TRUE)) )
    invisible( lapply(nets, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3)[, 1:2])) )

    # after alignment
    par(mar=c(0.1, 0.1, 0.1, 0.1), mfrow=c(2,2))
    invisible( lapply(nets.aln, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3, full=TRUE)[, 1:2], 
               full=TRUE)) )
    invisible( lapply(nets.aln, function(x) 
       plot(x, layout=layout.cna(x, pdb=pdb, k=3)[, 1:2])) )

    par(op)     

    }
  }
}
}
\seealso{
\code{\link{cna}}, \code{\link{plot.cna}}, \code{\link{vmd.cna}}
}
\keyword{analysis}
