% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlap}
\alias{overlap}
\title{Overlap Coefficient}
\usage{
overlap(
  x,
  y,
  method_density = "kernel",
  method_auc = "trapezoid",
  precision = 2^10,
  extend = TRUE,
  extend_scale = 0.1,
  ...
)
}
\arguments{
\item{x}{Vector of x values.}

\item{y}{Vector of x values.}

\item{method_density}{Density estimation method. See \code{\link[=estimate_density]{estimate_density()}}.}

\item{method_auc}{Area Under the Curve (AUC) estimation method. See \code{\link[=area_under_curve]{area_under_curve()}}.}

\item{precision}{Number of points of density data. See the \code{n} parameter in \code{density}.}

\item{extend}{Extend the range of the x axis by a factor of \code{extend_scale}.}

\item{extend_scale}{Ratio of range by which to extend the x axis. A value of \code{0.1} means that the x axis will be extended by \code{1/10} of the range of the data.}

\item{...}{Currently not used.}
}
\description{
A method to calculate the overlap coefficient between two empirical distributions (that can be used as a measure of similarity between two samples).
}
\examples{
library(bayestestR)

x <- distribution_normal(1000, 2, 0.5)
y <- distribution_normal(1000, 0, 1)

overlap(x, y)
plot(overlap(x, y))
}
