% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{findConfFile}
\alias{findConfFile}
\title{Find a batchtools Configuration File}
\usage{
findConfFile()
}
\value{
[\code{character(1)}] Path to the configuration file or \code{NA} if no configuration file was found.
}
\description{
This functions returns the path to the first configuration file found in the following locations:
  \enumerate{
   \item{File \dQuote{batchtools.conf.R} in the path specified by the environment variable \dQuote{R_BATCHTOOLS_SEARCH_PATH}.}
   \item{File \dQuote{batchtools.conf.R} in the current working directory.}
   \item{File \dQuote{config.R} in the user configuration directory as reported by \code{rappdirs::user_config_dir("batchtools", expand = FALSE)} (depending on OS, e.g., on linux this usually resolves to \dQuote{~/.config/batchtools/config.R}).}
   \item{\dQuote{.batchtools.conf.R} in the home directory (\dQuote{~}).}
   \item{\dQuote{config.R} in the site config directory as reported by \code{rappdirs::site_config_dir("batchtools")} (depending on OS). This file can be used for admins to set sane defaults for a computation site.}
  }
}
\keyword{internal}
