% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice.R
\encoding{UTF-8}
\name{nice}
\alias{nice}
\alias{nice.afex_aov}
\alias{nice.anova}
\alias{nice.mixed}
\alias{print.nice_table}
\title{Make nice ANOVA table for printing.}
\usage{
nice(object, ...)

\method{nice}{afex_aov}(
  object,
  es = attr(object$anova_table, "es"),
  observed = attr(object$anova_table, "observed"),
  correction = attr(object$anova_table, "correction"),
  MSE = NULL,
  intercept = NULL,
  p_adjust_method = attr(object$anova_table, "p_adjust_method"),
  sig_symbols = attr(object$anova_table, "sig_symbols"),
  ...
)

\method{nice}{anova}(
  object,
  MSE = NULL,
  intercept = NULL,
  sig_symbols = attr(object, "sig_symbols"),
  sig.symbols,
  ...
)

\method{nice}{mixed}(object, sig_symbols = attr(object$anova_table, "sig_symbols"), ...)

\method{print}{nice_table}(x, ...)
}
\arguments{
\item{object, x}{An object of class \code{"afex_aov"} (see
\code{\link{aov_car}}) or of class \code{"mixed"} (see \code{\link{mixed}})
as returned from the \pkg{afex} functions. Alternatively, an object of
class \code{"Anova.mlm"} or \code{"anova"} as returned from
\code{\link[car]{Anova}}.}

\item{...}{currently ignored.}

\item{es}{Effect Size to be reported. The default is given by
\code{afex_options("es_aov")}, which is initially set to \code{"ges"}
(i.e., reporting generalized eta-squared, see details). Also supported is
partial eta-squared (\code{"pes"}) or \code{"none"}.}

\item{observed}{character vector referring to the observed (i.e., non
manipulated) variables/effects in the design. Important for calculation of
generalized eta-squared (ignored if \code{es} is not \code{"ges"}), see
details.}

\item{correction}{Character. Which sphericity correction of the degrees of
freedom should be reported for the within-subject factors.  The default is
given by \code{afex_options("correction_aov")}, which is initially set to
\code{"GG"} corresponding to the Greenhouse-Geisser correction. Possible
values are \code{"GG"}, \code{"HF"} (i.e., Hyunh-Feldt correction), and
\code{"none"} (i.e., no correction).}

\item{MSE}{logical. Should the column containing the Mean Sqaured Error (MSE)
be displayed? Default is \code{TRUE}.}

\item{intercept}{logical. Should intercept (if present) be included in the
ANOVA table? Default is \code{FALSE} which hides the intercept.}

\item{p_adjust_method}{\code{character} indicating if p-values for individual
effects should be adjusted for multiple comparisons (see
\link[stats]{p.adjust} and details). The default \code{NULL} corresponds to
no adjustment.}

\item{sig_symbols}{Character. What should be the symbols designating
significance? When entering an vector with \code{length(sig.symbol) < 4}
only those elements of the default (\code{c(" +", " *", " **", " ***")})
will be replaced. \code{sig_symbols = ""} will display the stars but not
the \code{+}, \code{sig_symbols = rep("", 4)} will display no symbols. The
default is given by \code{afex_options("sig_symbols")}.}

\item{sig.symbols}{deprecated argument, only for backwards compatibility, use
\code{"sig_symbols"} instead.}
}
\value{
A \code{data.frame} of class \code{nice_table} with the ANOVA table
  consisting of characters. The columns that are always present are:
  \code{Effect}, \code{df} (degrees of freedom), \code{F}, and \code{p}.

  \code{ges} contains the generalized eta-squared effect size measure
  (Bakeman, 2005), \code{pes} contains partial eta-squared (if requested).
}
\description{
This generic function produces a nice ANOVA table for printing for objects of
class. \code{nice_anova} takes an object from \code{\link[car]{Anova}}
possible created by the convenience functions \code{\link{aov_ez}} or
\code{\link{aov_car}}. When within-subject factors are present, either
sphericity corrected or uncorrected degrees of freedom can be reported.
}
\details{
The returned \code{data.frame} is print-ready when adding to a
  document with proper methods. Either directly via \pkg{knitr} or similar
  approaches such as via package \pkg{xtable} (nowadays \pkg{knitr} is
  probably the best approach, see \href{http://yihui.name/knitr/}{here}).
  \pkg{xtable} converts a \code{data.frame} into LaTeX code with many
  possible options (e.g., allowing for \code{"longtable"} or
  \code{"sidewaystable"}), see \code{\link[xtable]{xtable}} and
  \code{\link[xtable]{print.xtable}}. See Examples.

  Conversion functions to other formats (such as HTML, ODF, or Word) can be
  found at the
  \href{https://CRAN.R-project.org/view=ReproducibleResearch}{Reproducible
  Research Task View}.

  The default reports generalized eta squared (Olejnik & Algina, 2003), the
  "recommended effect size for repeated measured designs" (Bakeman, 2005).
  Note that it is important that all measured variables (as opposed to
  experimentally manipulated variables), such as e.g., age, gender, weight,
  ..., must be declared via \code{observed} to obtain the correct effect size
  estimate. Partial eta squared (\code{"pes"}) does not require this.

  Exploratory ANOVA, for which no detailed hypotheses have been specified a
  priori, harbor a multiple comparison problem (Cramer et al., 2015). To
  avoid an inflation of familywise Type I error rate, results need to be
  corrected for multiple comparisons using \code{p_adjust_method}.
  \code{p_adjust_method} defaults to the method specified in the call to
  \code{\link{aov_car}} in \code{anova_table}. If no method was specified and
  \code{p_adjust_method = NULL} p-values are not adjusted.
}
\examples{

## example from Olejnik & Algina (2003)
# "Repeated Measures Design" (pp. 439):
data(md_12.1)
# create object of class afex_aov:
rmd <- aov_ez("id", "rt", md_12.1, within = c("angle", "noise"))
rmd
nice(rmd)
str(nice(rmd))
# use different es:
nice(rmd, es = "pes") # noise: .82
nice(rmd, es = "ges") # noise: .39

# same data other approach:
rmd2 <- aov_ez("id", "rt", md_12.1, within = c("angle", "noise"), 
               anova_table=list(correction = "none", es = "none"))
nice(rmd2)
nice(rmd2, correction = "GG")
nice(rmd2, correction = "GG", es = "ges")

# exampel using obk.long (see ?obk.long), a long version of the OBrienKaiser dataset from car.
data(obk.long)
# create object of class afex_aov:
tmp.aov <- aov_car(value ~ treatment * gender + Error(id/phase*hour), data = obk.long)

nice(tmp.aov, observed = "gender")

nice(tmp.aov, observed = "gender", sig_symbols = rep("", 4))

\dontrun{
# use package ascii or xtable for formatting of tables ready for printing.

full <- nice(tmp.aov, observed = "gender")

require(ascii)
print(ascii(full, include.rownames = FALSE, caption = "ANOVA 1"), type = "org")

require(xtable)
print.xtable(xtable(full, caption = "ANOVA 2"), include.rownames = FALSE)
}
}
\references{
Bakeman, R. (2005). Recommended effect size statistics for
  repeated measures designs. \emph{Behavior Research Methods}, 37(3),
  379-384. doi:10.3758/BF03192707

  Cramer, A. O. J., van Ravenzwaaij, D., Matzke, D., Steingroever, H.,
  Wetzels, R., Grasman, R. P. P. P., ... Wagenmakers, E.-J. (2015). Hidden
  multiplicity in exploratory multiway ANOVA: Prevalence and remedies.
  \emph{Psychonomic Bulletin & Review}, 1-8.
  doi:\href{http://doi.org/10.3758/s13423-015-0913-5}{10.3758/s13423-015-0913-5}


  Olejnik, S., & Algina, J. (2003). Generalized Eta and Omega Squared
  Statistics: Measures of Effect Size for Some Common Research Designs.
  \emph{Psychological Methods}, 8(4), 434-447. doi:10.1037/1082-989X.8.4.434
}
\seealso{
\code{\link{aov_ez}} and \code{\link{aov_car}} are the convenience
  functions to create the object appropriate for \code{nice_anova}.
}
\author{
The code for calculating generalized eta-squared was written by Mike
  Lawrence.\cr Everything else was written by Henrik Singmann.
}
