% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRowData.R
\name{plotRowData}
\alias{plotRowData}
\title{Plot row metadata}
\usage{
plotRowData(
  object,
  y,
  x = NULL,
  colour_by = color_by,
  shape_by = NULL,
  size_by = NULL,
  by_exprs_values = "logcounts",
  other_fields = list(),
  color_by = NULL,
  by.assay.type = by_exprs_values,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object containing expression values and experimental information.}

\item{y}{String specifying the column-level metadata field to show on the y-axis.
Alternatively, an \link{AsIs} vector or data.frame, see \code{?\link{retrieveFeatureInfo}}.}

\item{x}{String specifying the column-level metadata to show on the x-axis.
Alternatively, an \link{AsIs} vector or data.frame, see \code{?\link{retrieveFeatureInfo}}.
If \code{NULL}, nothing is shown on the x-axis.}

\item{colour_by}{Specification of a row metadata field or a cell to colour by, see \code{?\link{retrieveFeatureInfo}} for possible values.}

\item{shape_by}{Specification of a row metadata field or a cell to shape by, see \code{?\link{retrieveFeatureInfo}} for possible values.}

\item{size_by}{Specification of a row metadata field or a cell to size by, see \code{?\link{retrieveFeatureInfo}} for possible values.}

\item{by_exprs_values}{Alias to \code{by.assay.type}.}

\item{other_fields}{Additional feature-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.}

\item{color_by}{Alias to \code{colour_by}.}

\item{by.assay.type}{A string or integer scalar specifying which assay to obtain expression values from, 
for use in point aesthetics - see \code{?\link{retrieveFeatureInfo}} for details.}

\item{...}{Additional arguments for visualization, see \code{?"\link{scater-plot-args}"} for details.}
}
\value{
A \link{ggplot} object.
}
\description{
Plot row-level (i.e., gene) metadata from a SingleCellExperiment object.
}
\details{
If \code{y} is continuous and \code{x=NULL}, a violin plot is generated.
If \code{x} is categorical, a grouped violin plot will be generated, with one violin for each level of \code{x}.
If \code{x} is continuous, a scatter plot will be generated.

If \code{y} is categorical and \code{x} is continuous, horizontal violin plots will be generated.
If \code{x} is missing or categorical, rectangule plots will be generated where the area of a rectangle is proportional to the number of points for a combination of factors.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
rowData(example_sce) <- cbind(rowData(example_sce), 
    perFeatureQCMetrics(example_sce))

plotRowData(example_sce, y="detected", x="mean") +
    scale_x_log10()

}
