% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickLoadObject.R
\name{quickLoadObject}
\alias{quickLoadObject}
\alias{readLocalObject}
\alias{saveLocalObject}
\alias{quickStageObject}
\title{Convenience helpers for handling local directories}
\usage{
quickLoadObject(dir, path, ...)

quickStageObject(x, dir, path, ...)
}
\arguments{
\item{dir}{String containing a path to the directory.}

\item{path}{String containing a relative path to the object of interest inside \code{dir}.}

\item{...}{Further arguments to pass to \code{\link{loadObject}} (for \code{quickLoadObject}) or \code{\link{stageObject}} (for \code{quickStageObject}).}

\item{x}{Object to be saved.}
}
\value{
For \code{quickLoadObject}, the object at \code{path}.

For \code{quickStageObject}, the object is saved to \code{path} inside \code{dir}.
All necessary directories are created if they are not already present.
A \code{NULL} is returned invisibly.
}
\description{
\emph{WARNING: these functions are deprecated as the saving/reading functions are already simple enough in the newer versions of the \pkg{alabaster} framework.}
Read and write objects from a local staging directory.
These are just convenience wrappers around functions like \code{\link{loadObject}}, \code{\link{stageObject}} and \code{\link{writeMetadata}}.
}
\examples{
local <- tempfile()

# Creating a slightly complicated object:
library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])
df$C <- DataFrame(D=letters[1:10], E=runif(10))

# Saving it:
quickStageObject(df, local, "FOOBAR")

# Reading it back:
quickLoadObject(local, "FOOBAR")

}
\author{
Aaron Lun
}
