///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/viewport/SceneRenderer.h>
#include "DefaultSceneRenderer.h"

namespace Core {

/// Contains the stack of active scene renderers.
QVector<SceneRenderer*> SceneRenderer::renderers;

// This helper struct creates an instance of the DefaultSceneRenderer class
// and pushes it onto the renderer stack on program startup.
struct SceneRendererStackInitializer : public DefaultSceneRenderer {
	SceneRendererStackInitializer() { pushSceneRenderer(this); }
} _instance;

/******************************************************************************
* Returns the active scene renderer. This is the renderer that
* is on top of the scene renderer stack.
******************************************************************************/
SceneRenderer* SceneRenderer::activeRenderer() 
{
	OVITO_ASSERT(!renderers.empty());
	return renderers.back();
}

/******************************************************************************
* Pushes a scene renderer onto the stack. The renderer becomes
* the new active scene renderer.
******************************************************************************/
void SceneRenderer::pushSceneRenderer(SceneRenderer* renderer)
{
	renderers.push_back(renderer);
}

/******************************************************************************
* Removes the given scene renderer from the stack of renderers.
* It will be removed from stack even if it is not on top of the stack.
******************************************************************************/
void SceneRenderer::popSceneRenderer(SceneRenderer* renderer)
{
	renderers.remove(renderers.indexOf(renderer));
	OVITO_ASSERT(!renderers.empty());
}

};
