///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/utilities/PathManager.h>
#include "XFormCenterChooser.h"

namespace Core {

/******************************************************************************
* Initializes the combo box.
******************************************************************************/
XFormCenterChooser::XFormCenterChooser(wxWindow* parent) : 
	CustomButton(parent, wxID_ANY, wxEmptyString),
	icons(PATH_MANAGER.GetResourcePath(CORE_PLUGIN_ID, _T("XFormCenterChooser.png")), 24)
{
	SetToolTip(_("Transformation Center"));

	// Add items.
	SetIcon(&icons, 2);
	SetDisabledIcon(3);
	SetLabel(_("Selection"));

	AddFlyOff(_("Local"), 0, 1);
	AddFlyOff(_("Origin"), 4, 5);

	// Select current item.
	SetFlyOffIndex(XFORM_MANAGER.GetCenterMode() - XFormManager::SELECTION_CENTER);
	
	// Register as listener.
	XFORM_MANAGER.RegisterChangeListener(this);
}

/******************************************************************************
* Destructor.
******************************************************************************/
XFormCenterChooser::~XFormCenterChooser()
{
	XFORM_MANAGER.UnregisterChangeListener(this);
}

/******************************************************************************
* Is called when the user has choosen an item from the list.
******************************************************************************/
void XFormCenterChooser::OnSelectionChanged(wxCommandEvent& event)
{
	XFormManager::XFormCenterModes sys = (XFormManager::XFormCenterModes)(XFormManager::SELECTION_CENTER + GetFlyOffIndex());
	wxASSERT(sys >= XFormManager::SELECTION_CENTER && sys <= XFormManager::SYSTEM_ORIGIN);
	XFORM_MANAGER.SetCenterMode(sys);
}

/******************************************************************************
* Is called when the xform system or the xform center have been changed.
******************************************************************************/
void XFormCenterChooser::OnXFormModeChanged()
{
	// Update current item.
	SetFlyOffIndex(XFORM_MANAGER.GetCenterMode() - XFormManager::SELECTION_CENTER);
}

};
