/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class MPutMethod
extends XMLResponseMethodBase {
    private static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected Hashtable toSet = new Hashtable();
    protected String requestPath = "";
    protected String resourceURI = "";

    public MPutMethod() {
    }

    public MPutMethod(String path, String uri) {
        super(path);
        this.requestPath = path;
        this.resourceURI = uri;
    }

    public void setResourceURI(String uri) {
        this.resourceURI = uri;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void addPropertyToSet(String name, Object value) {
        this.checkNotUsed();
        Property propertyToSet = new Property();
        if (name != null) {
            propertyToSet.name = name;
            propertyToSet.value = value != null ? value : "";
            this.toSet.put(name, propertyToSet);
        }
    }

    public void addPropertyToSet(String name, Object value, String namespace, String namespaceInfo) {
        this.checkNotUsed();
        Property propertyToSet = new Property();
        if (name != null) {
            propertyToSet.name = name;
            propertyToSet.value = value != null ? value : "";
            propertyToSet.namespace = namespace;
            propertyToSet.namespaceInfo = namespaceInfo;
            this.toSet.put(namespace + name, propertyToSet);
        }
    }

    public String getName() {
        return "MPUT";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("rdf", RDFNS, "RDF", 0);
        if (this.toSet.size() > 0) {
            printer.writeElement("rdf", RDFNS, "Description", 0, "rdf:about=\"" + this.resourceURI + "\"");
            Enumeration toSetList = this.toSet.elements();
            while (toSetList.hasMoreElements()) {
                Property current = (Property)toSetList.nextElement();
                Object value = current.value;
                if (value instanceof Vector) {
                    Iterator values = ((Vector)value).iterator();
                    while (values.hasNext()) {
                        printer.writeProperty(current.namespace, current.namespaceInfo, current.name, values.next().toString());
                    }
                    continue;
                }
                if (value instanceof String) {
                    printer.writeProperty(current.namespace, current.namespaceInfo, current.name, (String)value);
                    continue;
                }
                if (value == null) continue;
                printer.writeProperty(current.namespace, current.namespaceInfo, current.name, value.toString());
            }
            printer.writeElement("rdf", "Description", 1);
        }
        printer.writeElement("rdf", "RDF", 1);
        return printer.toString();
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 409 || code == 207 || code == 403) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private class Property {
        public String name = "";
        public String namespace;
        public String namespaceInfo;
        public Object value;

        private Property() {
        }
    }
}

