/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.sort.StringCollator;

public class LowercaseFirstCollator
implements StringCollator,
Serializable {
    private StringCollator baseCollator;

    public LowercaseFirstCollator(StringCollator base) {
        this.baseCollator = base;
    }

    public int compareStrings(String a, String b) {
        int diff = this.baseCollator.compareStrings(a, b);
        if (diff != 0) {
            return diff;
        }
        int i = 0;
        int j = 0;
        while (true) {
            if (i < a.length() && j < b.length() && a.charAt(i) == b.charAt(j)) {
                ++i;
                ++j;
                continue;
            }
            while (i < a.length() && !Character.isLetter(a.charAt(i))) {
                ++i;
            }
            while (j < b.length() && !Character.isLetter(b.charAt(j))) {
                ++j;
            }
            if (i >= a.length()) {
                return 0;
            }
            if (j >= b.length()) {
                return 0;
            }
            boolean aLower = Character.isLowerCase(a.charAt(i++));
            boolean bLower = Character.isLowerCase(b.charAt(j++));
            if (aLower && !bLower) {
                return -1;
            }
            if (bLower && !aLower) break;
        }
        return 1;
    }

    public boolean comparesEqual(String s1, String s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    public Object getCollationKey(String s) {
        return this.baseCollator.getCollationKey(s);
    }
}

