/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

/*
 * RootSelectorPanel.java
 *
 * Created on Dec 1, 2008, 2:41:58 PM
 */

package org.netbeans.modules.remotefs.versioning.api;

import java.awt.Dialog;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

/**
 *
 * @author Tomas Stuka
 */
public class FileSelector extends javax.swing.JPanel implements ListSelectionListener {
    private final DialogDescriptor dialogDescriptor;
    private final JButton okButton;
    private final JButton cancelButton;
    private final String text;
    private final String title;
    private final HelpCtx helpCtx;
    private final Preferences pref;
    private static final String FILE_SELECTOR_PREFIX = "fileSelector";                               // NOI18N
    private static final Logger LOG = Logger.getLogger(FileSelector.class.getName());

    /** Creates new form RootSelectorPanel */
    public FileSelector(String text, String title, HelpCtx helpCtx, Preferences pref) {
        this.text = text;
        this.title = title;
        this.helpCtx = helpCtx;
        this.pref = pref;

        initComponents();

        filesList.addListSelectionListener(this);

        dialogDescriptor = new DialogDescriptor(this, title);

        okButton = new JButton(org.openide.util.NbBundle.getMessage(FileSelector.class, "CTL_FileSelector_Select"));
        okButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileSelector.class, "CTL_FileSelector_Select"));
        okButton.setEnabled(false);
        cancelButton = new JButton(org.openide.util.NbBundle.getMessage(FileSelector.class, "CTL_FileSelector_Cancel"));                                      // NOI18N
        cancelButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileSelector.class, "CTL_FileSelector_Cancel"));    // NOI18N
        dialogDescriptor.setOptions(new Object[] {okButton, cancelButton});

        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();

        jLabel1.setText(text);

        filesList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane1.setViewportView(filesList);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 606, Short.MAX_VALUE)
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 109, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JList filesList = new javax.swing.JList();
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    public boolean show(VCSFileProxy[] files) {
        Arrays.sort(files);
        DefaultListModel m = new DefaultListModel();
        for (VCSFileProxy file : files) {
            m.addElement(file);
        }
        filesList.setModel(m);
        preselectFile(files);

        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(title);                     // NOI18N

        dialogDescriptor.setHelpCtx(helpCtx);
        dialog.setVisible(true);
        boolean ret = dialogDescriptor.getValue() == okButton;
        if(ret) {
            saveSelectedFile(files);
        }
        return ret;
    }

    public VCSFileProxy getSelectedFile() {
        return (VCSFileProxy) filesList.getSelectedValue();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean enabled = filesList.getSelectedValue() != null;
        dialogDescriptor.setValid(enabled);
        okButton.setEnabled(enabled);
    }

    private void preselectFile(VCSFileProxy[] files) {
        String hash = getHash(files);
        if(hash == null || hash.trim().equals("")) {
            return;
        }
        String path = getFileSelectorPreset(hash);
        if(path != null && !path.trim().equals("")) {
            VCSFileProxy f = VCSFileProxySupport.fromString(path);
            filesList.setSelectedValue(f, true);
        }
    }

    private void saveSelectedFile(VCSFileProxy[] files) {
        String hash = getHash(files);
        if(hash == null || hash.trim().equals("")) {
            return;
        }
        VCSFileProxy file = getSelectedFile();
        if(file != null) {
            setFileSelectorPreset(hash, VCSFileProxySupport.toString(file));
        }
    }

    private String getHash(VCSFileProxy[] files) {
        Arrays.sort(files);
        StringBuilder sb = new StringBuilder();
        for (VCSFileProxy file : files) {
            sb.append(VCSFileProxySupport.toString(file));
        }
        String hash = null;
        try {
            hash = org.netbeans.modules.versioning.util.Utils.getHash("MD5", sb.toString().getBytes()); //NOI18N
        } catch (NoSuchAlgorithmException ex) {
            LOG.log(Level.SEVERE, null, ex); // should not happen
        }
        return hash;
    }

    public String getFileSelectorPreset(String hash) {
        return pref.get(FILE_SELECTOR_PREFIX + "-" + hash, ""); //NOI18N
    }

    public void setFileSelectorPreset(String hash, String path) {
        pref.put(FILE_SELECTOR_PREFIX + "-" + hash, path); //NOI18N
    }


}
