/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import sharpen.core.Mappings;
import sharpen.core.NameScope;
import sharpen.core.SharpenAnnotations;
import sharpen.core.framework.Environments;

public class NameScopeImpl
implements NameScope {
    private Stack<TypeDeclaration> _currentType = new Stack();
    private List<String> _mappedMethodDeclarations = new ArrayList<String>();

    @Override
    public boolean contains(String name) {
        return this._mappedMethodDeclarations.contains(name);
    }

    @Override
    public void enterTypeDeclaration(TypeDeclaration node) {
        this._currentType.push(node);
        this._mappedMethodDeclarations.clear();
        MethodDeclaration[] methodDeclarationArray = node.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration meth = methodDeclarationArray[n2];
            if (!SharpenAnnotations.hasIgnoreAnnotation((BodyDeclaration)meth)) {
                this._mappedMethodDeclarations.add(Environments.my(Mappings.class).mappedMethodName(meth.resolveBinding()));
            }
            ++n2;
        }
    }

    @Override
    public void leaveTypeDeclaration(TypeDeclaration node) {
        this._currentType.pop();
    }

    @Override
    public TypeDeclaration currentType() {
        return this._currentType.peek();
    }
}

