// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Runtime.InteropServices;

internal static partial class Interop
{
    internal static partial class Advapi32
    {
        [DllImport(Interop.Libraries.Advapi32)]
        internal static extern uint EventWrite(ulong RegHandle, ref _EVENT_DESCRIPTOR EventDescriptor, uint UserDataCount, IntPtr UserData);

        [StructLayout(LayoutKind.Sequential)]
        internal struct _EVENT_DESCRIPTOR
        {
            internal ushort Id;
            internal byte Version;
            internal byte Channel;
            internal byte Level;
            internal byte Opcode;
            internal ushort Task;
            internal ulong Keyword;
        }
    }
}
