//
// System.Net.Configuration.NetAuthenticationModuleHandler
//
// Authors:
//	Gonzalo Paniagua Javier (gonzalo@ximian.com)
//
// (C) 2003 Ximian, Inc (http://www.ximian.com)
//

//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Collections;
using System.Configuration;
#if (XML_DEP)
using System.Xml;
#else
using XmlNode = System.Object;
#endif

namespace System.Net.Configuration
{
	class NetAuthenticationModuleHandler : IConfigurationSectionHandler
	{
		public virtual object Create (object parent, object configContext, XmlNode section)
		{
#if (XML_DEP)			
			if (section.Attributes != null && section.Attributes.Count != 0)
				HandlersUtil.ThrowException ("Unrecognized attribute", section);

			XmlNodeList httpHandlers = section.ChildNodes;
			foreach (XmlNode child in httpHandlers) {
				XmlNodeType ntype = child.NodeType;
				if (ntype == XmlNodeType.Whitespace || ntype == XmlNodeType.Comment)
					continue;

				if (ntype != XmlNodeType.Element)
					HandlersUtil.ThrowException ("Only elements allowed", child);
				
				string name = child.Name;
				if (name == "clear") {
					if (child.Attributes != null && child.Attributes.Count != 0)
						HandlersUtil.ThrowException ("Unrecognized attribute", child);

					AuthenticationManager.Clear ();
					continue;
				}

				string type = HandlersUtil.ExtractAttributeValue ("type", child);
				if (child.Attributes != null && child.Attributes.Count != 0)
					HandlersUtil.ThrowException ("Unrecognized attribute", child);

				if (name == "add") {
					AuthenticationManager.Register (CreateInstance (type, child));
					continue;
				}

				if (name == "remove") {
					AuthenticationManager.Unregister (CreateInstance (type, child));
					continue;
				}

				HandlersUtil.ThrowException ("Unexpected element", child);
			}

			return AuthenticationManager.RegisteredModules;
#else
			return null;
#endif			
		}

#if (XML_DEP)			
		static IAuthenticationModule CreateInstance (string typeName, XmlNode node)
		{
			IAuthenticationModule module = null;
			
			try {
				Type type = Type.GetType (typeName, true);
				module = (IAuthenticationModule) Activator.CreateInstance (type);
			} catch (Exception e) {
				HandlersUtil.ThrowException (e.Message, node);
			}

			return module;
		}
#endif		
	}
}

