/*******************************************************************************
* Copyright 2019 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "common_f32.hpp"
#include "jit_generator.hpp"

namespace dnnl {
namespace impl {
namespace cpu {

jit_avx_kernel_b0_sgemm_kern::jit_avx_kernel_b0_sgemm_kern()
    : jit_generator(nullptr, F32_COMPUTE_KERNEL_CODE_SIZE) {

#ifndef _WIN32

#define M rdi
#define N rsi
#define K rdx
#define A r8
#define B r9
#define C rcx
#define LDC r10

#define AA r15
#define I r11
#define J r12
#define H rax
#define AO rbx
#define BO rbp
#define CO1 r13
#define CO2 r14

#define OLD_C 8 + stacksize + rsp
#define OLD_LDC 16 + stacksize + rsp

#else

#define M rcx
#define N rdx
#define K r8
#define A rdi
#define B rsi
#define C r9
#define LDC r10
#define AA r15
#define I r11
#define J r12
#define H rax
#define AO rbx
#define BO rbp
#define CO1 r13
#define CO2 r14

#define OLD_A 40 + stacksize + rsp
#define OLD_B 48 + stacksize + rsp
#define OLD_C 56 + stacksize + rsp
#define OLD_LDC 64 + stacksize + rsp

#endif

    inLocalLabel();
    {

        Xbyak::Label l100c;
        Xbyak::Label l1068;
        Xbyak::Label l122c;
        Xbyak::Label l1248;
        Xbyak::Label l140c;
        Xbyak::Label l1418;
        Xbyak::Label l1488;
        Xbyak::Label l14e4;
        Xbyak::Label l154c;
        Xbyak::Label l1710;
        Xbyak::Label l1720;
        Xbyak::Label l18e4;
        Xbyak::Label l18f0;
        Xbyak::Label l1960;
        Xbyak::Label l19a4;
        Xbyak::Label l1a0c;
        Xbyak::Label l1bd0;
        Xbyak::Label l1bdc;
        Xbyak::Label l1da0;
        Xbyak::Label l1dac;
        Xbyak::Label l1e1c;
        Xbyak::Label l1e58;
        Xbyak::Label l1e5c;
        Xbyak::Label l1e8c;
        Xbyak::Label l1ee8;
        Xbyak::Label l20b0;
        Xbyak::Label l20cc;
        Xbyak::Label l2294;
        Xbyak::Label l22a0;
        Xbyak::Label l2310;
        Xbyak::Label l236c;
        Xbyak::Label l23d4;
        Xbyak::Label l259c;
        Xbyak::Label l25ac;
        Xbyak::Label l2774;
        Xbyak::Label l2780;
        Xbyak::Label l27f0;
        Xbyak::Label l2834;
        Xbyak::Label l289c;
        Xbyak::Label l2a0;
        Xbyak::Label l2a64;
        Xbyak::Label l2a70;
        Xbyak::Label l2bc;
        Xbyak::Label l2c38;
        Xbyak::Label l2c44;
        Xbyak::Label l2cb4;
        Xbyak::Label l2cf0;
        Xbyak::Label l2cf4;
        Xbyak::Label l2d24;
        Xbyak::Label l2d80;
        Xbyak::Label l2f48;
        Xbyak::Label l2f64;
        Xbyak::Label l312c;
        Xbyak::Label l3138;
        Xbyak::Label l31a8;
        Xbyak::Label l3204;
        Xbyak::Label l326c;
        Xbyak::Label l3434;
        Xbyak::Label l3444;
        Xbyak::Label l360c;
        Xbyak::Label l3618;
        Xbyak::Label l3688;
        Xbyak::Label l36cc;
        Xbyak::Label l3734;
        Xbyak::Label l38fc;
        Xbyak::Label l3908;
        Xbyak::Label l3ad0;
        Xbyak::Label l3adc;
        Xbyak::Label l3b4c;
        Xbyak::Label l3b88;
        Xbyak::Label l3b8c;
        Xbyak::Label l3bbc;
        Xbyak::Label l3c18;
        Xbyak::Label l3de0;
        Xbyak::Label l3df8;
        Xbyak::Label l3fc0;
        Xbyak::Label l3fcc;
        Xbyak::Label l403c;
        Xbyak::Label l4098;
        Xbyak::Label l4100;
        Xbyak::Label l42c8;
        Xbyak::Label l42d8;
        Xbyak::Label l44a0;
        Xbyak::Label l44ac;
        Xbyak::Label l451c;
        Xbyak::Label l4560;
        Xbyak::Label l45c8;
        Xbyak::Label l4790;
        Xbyak::Label l479c;
        Xbyak::Label l48c;
        Xbyak::Label l4964;
        Xbyak::Label l4970;
        Xbyak::Label l498;
        Xbyak::Label l49e0;
        Xbyak::Label l4a1c;
        Xbyak::Label l4a20;
        Xbyak::Label l50;
        Xbyak::Label l508;
        Xbyak::Label l5b0;
        Xbyak::Label l618;
        Xbyak::Label l74;
        Xbyak::Label l7e8;
        Xbyak::Label l7f8;
        Xbyak::Label l9c8;
        Xbyak::Label l9d4;
        Xbyak::Label la44;
        Xbyak::Label lac4;
        Xbyak::Label lb2c;
        Xbyak::Label lcfc;
        Xbyak::Label ld0;
        Xbyak::Label ld08;
        Xbyak::Label led8;
        Xbyak::Label lee4;
        Xbyak::Label lf54;
        Xbyak::Label lfc8;
        Xbyak::Label lfdc;

        preamble();
        auto stacksize = get_size_of_abi_save_regs();
#ifdef _WIN32
        mov(A, ptr[OLD_A]);
        mov(B, ptr[OLD_B]);
#endif
        mov(C, ptr[OLD_C]);
        mov(LDC, ptr[OLD_LDC]);

        mov(M, qword[M]);
        mov(N, qword[N]);
        mov(K, qword[K]);
        shl(LDC, 0x2);
        sub(A, -128);
        sub(B, -128);
        mov(J, M);
        cmp(J, 0x10);
        jl(lfdc, T_NEAR);
        align(4);

        L(l50);
        mov(AA, K);
        imul(AA, AA, 0x40);
        add(AA, A);
        mov(CO1, C);
        add(C, 0x40);
        mov(BO, B);
        mov(I, N);
        cmp(I, 0x4);
        jl(l5b0, T_NEAR);
        align(4);

        L(l74);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l48c, T_NEAR);
        sub(H, 0x1e);
        jle(l2a0, T_NEAR);
        align(4);

        L(ld0);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO + 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO + 0x60]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO + 0x80]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0xa0]);
        sub(AO, -256);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(ld0, T_NEAR);
        align(4);

        L(l2a0);
        prefetcht0(byte[CO1 + 0x3c]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x3c]);
        prefetcht0(byte[CO2 + 0x3c]);
        prefetcht0(byte[CO2 + LDC * 1 + 0x3c]);
        add(H, 0x1e);
        align(4);

        L(l2bc);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO + 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO + 0x60]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO + 0x80]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0xa0]);
        sub(AO, -256);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l2bc, T_NEAR);
        align(4);

        L(l48c);
        mov(H, K);
        and_(H, 0x3);
        je(l508, T_NEAR);
        align(4);

        L(l498);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x40]);
        vmovups(ymm1, yword[AO - 0x20]);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        sub(AO, -64);
        sub(BO, -16);
        dec(H);
        jg(l498, T_NEAR);
        align(4);

        L(l508);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vblendps(ymm0, ymm12, ymm13, 0xaa);
        vblendps(ymm1, ymm12, ymm13, 0x55);
        vblendps(ymm2, ymm14, ymm15, 0xaa);
        vblendps(ymm3, ymm14, ymm15, 0x55);
        vblendps(ymm12, ymm0, ymm2, 0xcc);
        vblendps(ymm13, ymm1, ymm3, 0xcc);
        vblendps(ymm14, ymm0, ymm2, 0x33);
        vblendps(ymm15, ymm1, ymm3, 0x33);
        vmovups(yword[CO1 + 0x0], ymm8);
        vmovups(yword[CO1 + 0x20], ymm12);
        vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
        vmovups(yword[CO1 + LDC * 1 + 0x20], ymm13);
        vmovups(yword[CO2], ymm10);
        vmovups(yword[CO2 + 0x20], ymm14);
        vmovups(yword[CO2 + LDC * 1], ymm11);
        vmovups(yword[CO2 + LDC * 1 + 0x20], ymm15);
        lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
        sub(I, 0x4);
        cmp(I, 0x4);
        jge(l74, T_NEAR);
        align(4);

        L(l5b0);
        test(I, 0x2);
        jle(lac4, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l9c8, T_NEAR);
        sub(H, 0x1e);
        jle(l7e8, T_NEAR);
        align(4);

        L(l618);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO + 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO + 0x60]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO + 0x80]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0xa0]);
        sub(AO, -256);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l618, T_NEAR);
        align(4);

        L(l7e8);
        prefetcht0(byte[CO1 + 0x3c]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x3c]);
        add(H, 0x1e);
        align(4);

        L(l7f8);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO + 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO + 0x60]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO + 0x80]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0xa0]);
        sub(AO, -256);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l7f8, T_NEAR);
        align(4);

        L(l9c8);
        mov(H, K);
        and_(H, 0x3);
        je(la44, T_NEAR);
        align(4);

        L(l9d4);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x40]);
        vmovups(ymm1, yword[AO - 0x20]);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        sub(AO, -64);
        sub(BO, -8);
        dec(H);
        jg(l9d4, T_NEAR);
        align(4);

        L(la44);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vblendps(ymm0, ymm12, ymm13, 0xaa);
        vblendps(ymm1, ymm12, ymm13, 0x55);
        vblendps(ymm2, ymm14, ymm15, 0xaa);
        vblendps(ymm3, ymm14, ymm15, 0x55);
        vblendps(ymm12, ymm0, ymm2, 0xcc);
        vblendps(ymm13, ymm1, ymm3, 0xcc);
        vblendps(ymm14, ymm0, ymm2, 0x33);
        vblendps(ymm15, ymm1, ymm3, 0x33);
        vmovups(yword[CO1 + 0x0], ymm8);
        vmovups(yword[CO1 + 0x20], ymm12);
        vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
        vmovups(yword[CO1 + LDC * 1 + 0x20], ymm13);
        lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
        align(4);

        L(lac4);
        test(I, 0x1);
        jle(lfc8, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(led8, T_NEAR);
        sub(H, 0x1e);
        jle(lcfc, T_NEAR);
        align(4);

        L(lb2c);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO + 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO + 0x60]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO + 0x80]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0xa0]);
        sub(AO, -256);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(lb2c, T_NEAR);
        align(4);

        L(lcfc);
        prefetcht0(byte[CO1 + 0x3c]);
        add(H, 0x1e);
        align(4);

        L(ld08);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO + 0x40]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO + 0x60]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO + 0x80]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0xa0]);
        sub(AO, -256);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(ld08, T_NEAR);
        align(4);

        L(led8);
        mov(H, K);
        and_(H, 0x3);
        je(lf54, T_NEAR);
        align(4);

        L(lee4);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x40]);
        vmovups(ymm1, yword[AO - 0x20]);
        vbroadcastf128(ymm2, xword[BO - 0x7c]);
        sub(AO, -64);
        sub(BO, -4);
        dec(H);
        jg(lee4, T_NEAR);
        align(4);

        L(lf54);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vblendps(ymm0, ymm12, ymm13, 0xaa);
        vblendps(ymm1, ymm12, ymm13, 0x55);
        vblendps(ymm2, ymm14, ymm15, 0xaa);
        vblendps(ymm3, ymm14, ymm15, 0x55);
        vblendps(ymm12, ymm0, ymm2, 0xcc);
        vblendps(ymm13, ymm1, ymm3, 0xcc);
        vblendps(ymm14, ymm0, ymm2, 0x33);
        vblendps(ymm15, ymm1, ymm3, 0x33);
        vmovups(yword[CO1 + 0x0], ymm8);
        vmovups(yword[CO1 + 0x20], ymm12);
        lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
        align(4);

        L(lfc8);
        mov(A, AO);
        sub(J, 0x10);
        cmp(J, 0x10);
        jge(l50, T_NEAR);
        align(4);

        L(lfdc);
        test(J, 0x8);
        jle(l1e5c, T_NEAR);
        mov(AA, K);
        imul(AA, AA, 0x20);
        add(AA, A);
        mov(CO1, C);
        add(C, 0x20);
        mov(BO, B);
        mov(I, N);
        cmp(I, 0x4);
        jl(l14e4, T_NEAR);
        align(4);

        L(l100c);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l140c, T_NEAR);
        sub(H, 0x1e);
        jle(l122c, T_NEAR);
        align(4);

        L(l1068);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x20]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        sub(AO, -128);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l1068, T_NEAR);
        align(4);

        L(l122c);
        prefetcht0(byte[CO1 + 0x1c]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x1c]);
        prefetcht0(byte[CO2 + 0x1c]);
        prefetcht0(byte[CO2 + LDC * 1 + 0x1c]);
        add(H, 0x1e);
        align(4);

        L(l1248);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x20]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        sub(AO, -128);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l1248, T_NEAR);
        align(4);

        L(l140c);
        mov(H, K);
        and_(H, 0x3);
        je(l1488, T_NEAR);
        align(4);

        L(l1418);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x60]);
        vmovups(ymm1, yword[AO - 0x40]);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        sub(AO, -32);
        sub(BO, -16);
        dec(H);
        jg(l1418, T_NEAR);
        align(4);

        L(l1488);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovups(yword[CO1 + 0x0], ymm8);
        vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
        vmovups(yword[CO2], ymm10);
        vmovups(yword[CO2 + LDC * 1], ymm11);
        lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
        sub(I, 0x4);
        cmp(I, 0x4);
        jge(l100c, T_NEAR);
        align(4);

        L(l14e4);
        test(I, 0x2);
        jle(l19a4, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l18e4, T_NEAR);
        sub(H, 0x1e);
        jle(l1710, T_NEAR);
        align(4);

        L(l154c);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x20]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        sub(AO, -128);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l154c, T_NEAR);
        align(4);

        L(l1710);
        prefetcht0(byte[CO1 + 0x1c]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x1c]);
        add(H, 0x1e);
        align(4);

        L(l1720);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x20]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        sub(AO, -128);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l1720, T_NEAR);
        align(4);

        L(l18e4);
        mov(H, K);
        and_(H, 0x3);
        je(l1960, T_NEAR);
        align(4);

        L(l18f0);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x60]);
        vmovups(ymm1, yword[AO - 0x40]);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        sub(AO, -32);
        sub(BO, -8);
        dec(H);
        jg(l18f0, T_NEAR);
        align(4);

        L(l1960);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovups(yword[CO1 + 0x0], ymm8);
        vmovups(yword[CO1 + LDC * 1 + 0x0], ymm9);
        lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
        align(4);

        L(l19a4);
        test(I, 0x1);
        jle(l1e58, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l1da0, T_NEAR);
        sub(H, 0x1e);
        jle(l1bd0, T_NEAR);
        align(4);

        L(l1a0c);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x20]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        sub(AO, -128);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l1a0c, T_NEAR);
        align(4);

        L(l1bd0);
        prefetcht0(byte[CO1 + 0x1c]);
        add(H, 0x1e);
        align(4);

        L(l1bdc);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x20]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO + 0x20]);
        sub(AO, -128);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l1bdc, T_NEAR);
        align(4);

        L(l1da0);
        mov(H, K);
        and_(H, 0x3);
        je(l1e1c, T_NEAR);
        align(4);

        L(l1dac);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x60]);
        vmovups(ymm1, yword[AO - 0x40]);
        vbroadcastf128(ymm2, xword[BO - 0x7c]);
        sub(AO, -32);
        sub(BO, -4);
        dec(H);
        jg(l1dac, T_NEAR);
        align(4);

        L(l1e1c);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovups(yword[CO1 + 0x0], ymm8);
        lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
        align(4);

        L(l1e58);
        mov(A, AO);
        align(4);

        L(l1e5c);
        test(J, 0x4);
        jle(l2cf4, T_NEAR);
        mov(AA, K);
        imul(AA, AA, 0x10);
        add(AA, A);
        mov(CO1, C);
        add(C, 0x10);
        mov(BO, B);
        mov(I, N);
        cmp(I, 0x4);
        jl(l236c, T_NEAR);
        align(4);

        L(l1e8c);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l2294, T_NEAR);
        sub(H, 0x1e);
        jle(l20b0, T_NEAR);
        align(4);

        L(l1ee8);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x50]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x30]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        sub(AO, -64);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l1ee8, T_NEAR);
        align(4);

        L(l20b0);
        prefetcht0(byte[CO1 + 0xc]);
        prefetcht0(byte[CO1 + LDC * 1 + 0xc]);
        prefetcht0(byte[CO2 + 0xc]);
        prefetcht0(byte[CO2 + LDC * 1 + 0xc]);
        add(H, 0x1e);
        align(4);

        L(l20cc);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x50]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x30]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        sub(AO, -64);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l20cc, T_NEAR);
        align(4);

        L(l2294);
        mov(H, K);
        and_(H, 0x3);
        je(l2310, T_NEAR);
        align(4);

        L(l22a0);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x70]);
        vmovups(ymm1, yword[AO - 0x50]);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        sub(AO, -16);
        sub(BO, -16);
        dec(H);
        jg(l22a0, T_NEAR);
        align(4);

        L(l2310);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovups(xword[CO1 + 0x0], xmm8);
        vmovups(xword[CO1 + LDC * 1 + 0x0], xmm9);
        vmovups(xword[CO2], xmm10);
        vmovups(xword[CO2 + LDC * 1], xmm11);
        lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
        sub(I, 0x4);
        cmp(I, 0x4);
        jge(l1e8c, T_NEAR);
        align(4);

        L(l236c);
        test(I, 0x2);
        jle(l2834, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l2774, T_NEAR);
        sub(H, 0x1e);
        jle(l259c, T_NEAR);
        align(4);

        L(l23d4);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x50]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x30]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        sub(AO, -64);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l23d4, T_NEAR);
        align(4);

        L(l259c);
        prefetcht0(byte[CO1 + 0xc]);
        prefetcht0(byte[CO1 + LDC * 1 + 0xc]);
        add(H, 0x1e);
        align(4);

        L(l25ac);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x50]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x30]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        sub(AO, -64);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l25ac, T_NEAR);
        align(4);

        L(l2774);
        mov(H, K);
        and_(H, 0x3);
        je(l27f0, T_NEAR);
        align(4);

        L(l2780);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x70]);
        vmovups(ymm1, yword[AO - 0x50]);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        sub(AO, -16);
        sub(BO, -8);
        dec(H);
        jg(l2780, T_NEAR);
        align(4);

        L(l27f0);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovups(xword[CO1 + 0x0], xmm8);
        vmovups(xword[CO1 + LDC * 1 + 0x0], xmm9);
        lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
        align(4);

        L(l2834);
        test(I, 0x1);
        jle(l2cf0, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l2c38, T_NEAR);
        sub(H, 0x1e);
        jle(l2a64, T_NEAR);
        align(4);

        L(l289c);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x50]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x30]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        sub(AO, -64);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l289c, T_NEAR);
        align(4);

        L(l2a64);
        prefetcht0(byte[CO1 + 0xc]);
        add(H, 0x1e);
        align(4);

        L(l2a70);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x50]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x30]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x40]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x20]);
        sub(AO, -64);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l2a70, T_NEAR);
        align(4);

        L(l2c38);
        mov(H, K);
        and_(H, 0x3);
        je(l2cb4, T_NEAR);
        align(4);

        L(l2c44);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x70]);
        vmovups(ymm1, yword[AO - 0x50]);
        vbroadcastf128(ymm2, xword[BO - 0x7c]);
        sub(AO, -16);
        sub(BO, -4);
        dec(H);
        jg(l2c44, T_NEAR);
        align(4);

        L(l2cb4);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovups(xword[CO1 + 0x0], xmm8);
        lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
        align(4);

        L(l2cf0);
        mov(A, AO);
        align(4);

        L(l2cf4);
        test(J, 0x2);
        jle(l3b8c, T_NEAR);
        mov(AA, K);
        imul(AA, AA, 0x8);
        add(AA, A);
        mov(CO1, C);
        add(C, 0x8);
        mov(BO, B);
        mov(I, N);
        cmp(I, 0x4);
        jl(l3204, T_NEAR);
        align(4);

        L(l2d24);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l312c, T_NEAR);
        sub(H, 0x1e);
        jle(l2f48, T_NEAR);
        align(4);

        L(l2d80);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x68]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x48]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        sub(AO, -32);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l2d80, T_NEAR);
        align(4);

        L(l2f48);
        prefetcht0(byte[CO1 + 0x4]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x4]);
        prefetcht0(byte[CO2 + 0x4]);
        prefetcht0(byte[CO2 + LDC * 1 + 0x4]);
        add(H, 0x1e);
        align(4);

        L(l2f64);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x68]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x48]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        sub(AO, -32);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l2f64, T_NEAR);
        align(4);

        L(l312c);
        mov(H, K);
        and_(H, 0x3);
        je(l31a8, T_NEAR);
        align(4);

        L(l3138);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x78]);
        vmovups(ymm1, yword[AO - 0x58]);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        sub(AO, -8);
        sub(BO, -16);
        dec(H);
        jg(l3138, T_NEAR);
        align(4);

        L(l31a8);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovlps(qword[CO1 + 0x0], xmm8);
        vmovlps(qword[CO1 + LDC * 1 + 0x0], xmm9);
        vmovlps(qword[CO2], xmm10);
        vmovlps(qword[CO2 + LDC * 1], xmm11);
        lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
        sub(I, 0x4);
        cmp(I, 0x4);
        jge(l2d24, T_NEAR);
        align(4);

        L(l3204);
        test(I, 0x2);
        jle(l36cc, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l360c, T_NEAR);
        sub(H, 0x1e);
        jle(l3434, T_NEAR);
        align(4);

        L(l326c);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x68]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x48]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        sub(AO, -32);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l326c, T_NEAR);
        align(4);

        L(l3434);
        prefetcht0(byte[CO1 + 0x4]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x4]);
        add(H, 0x1e);
        align(4);

        L(l3444);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x68]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x48]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        sub(AO, -32);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l3444, T_NEAR);
        align(4);

        L(l360c);
        mov(H, K);
        and_(H, 0x3);
        je(l3688, T_NEAR);
        align(4);

        L(l3618);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x78]);
        vmovups(ymm1, yword[AO - 0x58]);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        sub(AO, -8);
        sub(BO, -8);
        dec(H);
        jg(l3618, T_NEAR);
        align(4);

        L(l3688);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovlps(qword[CO1 + 0x0], xmm8);
        vmovlps(qword[CO1 + LDC * 1 + 0x0], xmm9);
        lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
        align(4);

        L(l36cc);
        test(I, 0x1);
        jle(l3b88, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l3ad0, T_NEAR);
        sub(H, 0x1e);
        jle(l38fc, T_NEAR);
        align(4);

        L(l3734);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x68]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x48]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        sub(AO, -32);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l3734, T_NEAR);
        align(4);

        L(l38fc);
        prefetcht0(byte[CO1 + 0x4]);
        add(H, 0x1e);
        align(4);

        L(l3908);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x68]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x48]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x60]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x40]);
        sub(AO, -32);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l3908, T_NEAR);
        align(4);

        L(l3ad0);
        mov(H, K);
        and_(H, 0x3);
        je(l3b4c, T_NEAR);
        align(4);

        L(l3adc);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x78]);
        vmovups(ymm1, yword[AO - 0x58]);
        vbroadcastf128(ymm2, xword[BO - 0x7c]);
        sub(AO, -8);
        sub(BO, -4);
        dec(H);
        jg(l3adc, T_NEAR);
        align(4);

        L(l3b4c);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovlps(qword[CO1 + 0x0], xmm8);
        lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
        align(4);

        L(l3b88);
        mov(A, AO);
        align(4);

        L(l3b8c);
        test(J, 0x1);
        jle(l4a20, T_NEAR);
        mov(AA, K);
        imul(AA, AA, 0x4);
        add(AA, A);
        mov(CO1, C);
        add(C, 0x4);
        mov(BO, B);
        mov(I, N);
        cmp(I, 0x4);
        jl(l4098, T_NEAR);
        align(4);

        L(l3bbc);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l3fc0, T_NEAR);
        sub(H, 0x1e);
        jle(l3de0, T_NEAR);
        align(4);

        L(l3c18);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x5c]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x74]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x54]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        sub(AO, -16);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l3c18, T_NEAR);
        align(4);

        L(l3de0);
        prefetcht0(byte[CO1 + 0x0]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x0]);
        prefetcht0(byte[CO2]);
        prefetcht0(byte[CO2 + LDC * 1]);
        add(H, 0x1e);
        align(4);

        L(l3df8);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x5c]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x50]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x74]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x54]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x40]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        sub(AO, -16);
        sub(BO, -64);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l3df8, T_NEAR);
        align(4);

        L(l3fc0);
        mov(H, K);
        and_(H, 0x3);
        je(l403c, T_NEAR);
        align(4);

        L(l3fcc);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmovups(ymm1, yword[AO - 0x5c]);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        sub(AO, -4);
        sub(BO, -16);
        dec(H);
        jg(l3fcc, T_NEAR);
        align(4);

        L(l403c);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovss(dword[CO1 + 0x0], xmm8);
        vmovss(dword[CO1 + LDC * 1 + 0x0], xmm9);
        vmovss(dword[CO2], xmm10);
        vmovss(dword[CO2 + LDC * 1], xmm11);
        lea(CO1, ptr[CO1 + LDC * 4 + 0x0]);
        sub(I, 0x4);
        cmp(I, 0x4);
        jge(l3bbc, T_NEAR);
        align(4);

        L(l4098);
        test(I, 0x2);
        jle(l4560, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l44a0, T_NEAR);
        sub(H, 0x1e);
        jle(l42c8, T_NEAR);
        align(4);

        L(l4100);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x5c]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x74]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x54]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        sub(AO, -16);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l4100, T_NEAR);
        align(4);

        L(l42c8);
        prefetcht0(byte[CO1 + 0x0]);
        prefetcht0(byte[CO1 + LDC * 1 + 0x0]);
        add(H, 0x1e);
        align(4);

        L(l42d8);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x5c]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x68]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x74]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x54]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x60]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        sub(AO, -16);
        sub(BO, -32);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l42d8, T_NEAR);
        align(4);

        L(l44a0);
        mov(H, K);
        and_(H, 0x3);
        je(l451c, T_NEAR);
        align(4);

        L(l44ac);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmovups(ymm1, yword[AO - 0x5c]);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        sub(AO, -4);
        sub(BO, -8);
        dec(H);
        jg(l44ac, T_NEAR);
        align(4);

        L(l451c);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovss(dword[CO1 + 0x0], xmm8);
        vmovss(dword[CO1 + LDC * 1 + 0x0], xmm9);
        lea(CO1, ptr[CO1 + LDC * 2 + 0x0]);
        align(4);

        L(l4560);
        test(I, 0x1);
        jle(l4a1c, T_NEAR);
        vxorps(ymm8, ymm8, ymm8);
        vbroadcastf128(ymm2, xword[BO - 0x80]);
        vxorps(ymm9, ymm9, ymm9);
        vmovups(ymm0, yword[A - 0x80]);
        vxorps(ymm10, ymm10, ymm10);
        vmovups(ymm1, yword[A - 0x60]);
        vxorps(ymm11, ymm11, ymm11);
        lea(CO2, ptr[CO1 + LDC * 2 + 0x0]);
        vxorps(ymm12, ymm12, ymm12);
        vxorps(ymm13, ymm13, ymm13);
        vxorps(ymm14, ymm14, ymm14);
        vxorps(ymm15, ymm15, ymm15);
        mov(AO, A);
        mov(H, K);
        sar(H, 0x2);
        jle(l4964, T_NEAR);
        sub(H, 0x1e);
        jle(l4790, T_NEAR);
        align(4);

        L(l45c8);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x5c]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x74]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x54]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        sub(AO, -16);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l45c8, T_NEAR);
        align(4);

        L(l4790);
        prefetcht0(byte[CO1 + 0x0]);
        add(H, 0x1e);
        align(4);

        L(l479c);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x180]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        prefetcht0(byte[BO + 0x100]);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x7c]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x5c]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x1c0]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x78]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        prefetcht0(byte[AA - 0x80]);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x78]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x58]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm2, ymm0);
        prefetcht0(byte[AO + 0x200]);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm3, xword[BO - 0x74]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm6, ymm2, ymm0);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm6, ymm2, ymm0);
        vmovups(ymm0, yword[AO - 0x74]);
        vmulps(ymm7, ymm2, ymm1);
        vmovups(ymm1, yword[AO - 0x54]);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        vmulps(ymm6, ymm3, ymm0);
        prefetcht0(byte[AO + 0x240]);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm8, ymm8, ymm6);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm9, ymm9, ymm6);
        vbroadcastf128(ymm2, xword[BO - 0x70]);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm3, ymm3, 0x1b);
        vmulps(ymm6, ymm3, ymm0);
        vmulps(ymm7, ymm3, ymm1);
        vaddps(ymm10, ymm10, ymm6);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm3, ymm3, 0xb1);
        add(AA, 0x4);
        vmulps(ymm6, ymm3, ymm0);
        vmovups(ymm0, yword[AO - 0x70]);
        vmulps(ymm7, ymm3, ymm1);
        vmovups(ymm1, yword[AO - 0x50]);
        sub(AO, -16);
        sub(BO, -16);
        vaddps(ymm11, ymm11, ymm6);
        vaddps(ymm15, ymm15, ymm7);
        sub(H, 0x1);
        jg(l479c, T_NEAR);
        align(4);

        L(l4964);
        mov(H, K);
        and_(H, 0x3);
        je(l49e0, T_NEAR);
        align(4);

        L(l4970);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm8, ymm8, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm12, ymm12, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm9, ymm9, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm13, ymm13, ymm7);
        vpermilps(ymm2, ymm2, 0x1b);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm10, ymm10, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm14, ymm14, ymm7);
        vpermilps(ymm2, ymm2, 0xb1);
        vmulps(ymm7, ymm2, ymm0);
        vaddps(ymm11, ymm11, ymm7);
        vmulps(ymm7, ymm2, ymm1);
        vaddps(ymm15, ymm15, ymm7);
        vmovups(ymm0, yword[AO - 0x7c]);
        vmovups(ymm1, yword[AO - 0x5c]);
        vbroadcastf128(ymm2, xword[BO - 0x7c]);
        sub(AO, -4);
        sub(BO, -4);
        dec(H);
        jg(l4970, T_NEAR);
        align(4);

        L(l49e0);
        vblendps(ymm0, ymm8, ymm9, 0xaa);
        vblendps(ymm1, ymm8, ymm9, 0x55);
        vblendps(ymm2, ymm10, ymm11, 0xaa);
        vblendps(ymm3, ymm10, ymm11, 0x55);
        vblendps(ymm8, ymm0, ymm2, 0xcc);
        vblendps(ymm9, ymm1, ymm3, 0xcc);
        vblendps(ymm10, ymm0, ymm2, 0x33);
        vblendps(ymm11, ymm1, ymm3, 0x33);
        vmovss(dword[CO1 + 0x0], xmm8);
        lea(CO1, ptr[CO1 + LDC * 1 + 0x0]);
        align(4);

        L(l4a1c);
        mov(A, AO);
        align(4);

        L(l4a20);

        postamble();
    }
    outLocalLabel();

#undef M
#undef N
#undef K
#undef A
#undef B
#undef C
#undef LDC
#undef AA
#undef I
#undef J
#undef H
#undef AO
#undef BO
#undef CO1
#undef CO2
#ifdef _WIN32
#undef OLD_A
#undef OLD_B
#endif
#undef OLD_C
#undef OLD_LDC
}

} // namespace cpu
} // namespace impl
} // namespace dnnl
