/* crtbegin object for windows32 targets.
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file into combinations with other programs,
and to distribute those combinations without any restriction coming
from the use of this file.  (The General Public License restrictions
do apply in other respects; for example, they cover modification of
the file, and distribution when not linked into a combine
executable.)

GCC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

/* Target machine header files require this define. */
#define IN_LIBGCC2

#include "auto-host.h"
#include "tconfig.h"
#include "tsystem.h"
#include "coretypes.h"
#include "tm.h"
#include "unwind-dw2-fde.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#ifndef LIBGCJ_SONAME
#define LIBGCJ_SONAME "libgcj_s.dll"
#endif

/* Make the declarations weak.  This is critical for
   _Jv_RegisterClasses because it lives in libgcj.a  */
extern void __register_frame_info (const void *, struct object *)
				   TARGET_ATTRIBUTE_WEAK;
extern void *__deregister_frame_info (const void *)
				      TARGET_ATTRIBUTE_WEAK;
extern void _Jv_RegisterClasses (const void *) TARGET_ATTRIBUTE_WEAK;

#if defined(HAVE_LD_RO_RW_SECTION_MIXING)
# define EH_FRAME_SECTION_CONST const
#else
# define EH_FRAME_SECTION_CONST
#endif

/* Stick a label at the beginning of the frame unwind info so we can
   register/deregister it with the exception handling library code.  */
#if DWARF2_UNWIND_INFO
static EH_FRAME_SECTION_CONST char __EH_FRAME_BEGIN__[]
  __attribute__((section(EH_FRAME_SECTION_NAME), aligned(4)))
  = { };

static struct object obj;
#endif

#if TARGET_USE_JCR_SECTION
static void *__JCR_LIST__[]
  __attribute__ ((unused, section(JCR_SECTION_NAME), aligned(4)))
  = { };
#endif

/* Pull in references from libgcc.a(unwind-dw2-fde.o) in the
   startfile. These are referenced by a ctor and dtor in crtend.o.  */
extern void __gcc_register_frame (void);
extern void __gcc_deregister_frame (void);

void
__gcc_register_frame (void)
{
#if DWARF2_UNWIND_INFO
  if (__register_frame_info)
     __register_frame_info (__EH_FRAME_BEGIN__, &obj);
#endif

#if TARGET_USE_JCR_SECTION 
  if (__JCR_LIST__[0])
    {
      void (*register_class_fn) (const void *);
      HANDLE h = GetModuleHandle (LIBGCJ_SONAME);
      if (h)
	register_class_fn = (void (*) (const void *))
			     GetProcAddress (h, "_Jv_RegisterClasses");
      else
	register_class_fn = _Jv_RegisterClasses;

      if (register_class_fn)
	register_class_fn (__JCR_LIST__);
    }
#endif
}

void
__gcc_deregister_frame (void)
{
#if DWARF2_UNWIND_INFO
  if ( __deregister_frame_info)
     __deregister_frame_info (__EH_FRAME_BEGIN__);
#endif
}

#ifdef __MINGW32__
/* On mingw, we can override the library versions of __do_globl_{c,d}tors
   and __main and call the registration functions directly.  */

typedef void (*func_ptr) (void);
extern func_ptr __CTOR_LIST__[];
extern func_ptr __DTOR_LIST__[];
extern void __main (void);

static void
__do_global_dtors (void)
{
  static func_ptr *p = __DTOR_LIST__ + 1;

  /*
   * Call each destructor in the destructor list until a null pointer
   * is encountered.
   */
  while (*p)
    {
      (*(p)) ();
      p++;
    }
   __gcc_deregister_frame ();
}

static void
__do_global_ctors (void)
{
  unsigned long nptrs = (unsigned long) __CTOR_LIST__[0];
  unsigned i;
  /* Do this before registering ctors. */
   __gcc_register_frame();

  /* If the first entry in the constructor list is -1 then the list
     is terminated with a null entry. Otherwise the first entry was
     the number of pointers in the list.  */
  if (nptrs == (unsigned long)-1)
    {
      for (nptrs = 0; __CTOR_LIST__[nptrs + 1] != 0; nptrs++)
	;
    }

  /* Go through the list backwards calling constructors.  */
  for (i = nptrs; i >= 1; i--)
    {
      __CTOR_LIST__[i] ();
    }

  /*
   * Register the destructors for processing on exit.
   */
  atexit (__do_global_dtors);
}

static int initialized = 0;

void
__main (void)
{
  if (!initialized)
    {
      initialized = 1;
      __do_global_ctors ();
    }
}
#endif
