#!/bin/ksh
# Backend-Skript fuer Fax-Server auf hades
# 05.09.95 Erster Versuch, einrichten der Queues und sammeln der 
#          Parameter (freidhof)
# 05.09.95 Erste Funktionsversion, keine Fehlerchecks (z.B. PS-Che.)
#          (freidhof)
# 07.09.95 Erweiterungen... User bekommt mail (kurpiers)
# 02.10.95 Ermittlung der Ruecksendeadresse mit c-Prog "get_address.c"
#          Vielleicht sollte man das ganze Prog. in c schreiben, da in
#          der "libqb" eine Schnittstelle zwischen qdaemon und Backend
#          definiert ist. Das ist einfacher, als sich die Daten ueber
#          Hintertueren mit Skripten zu besorgen.
#          Logfile und Sendebericht verbessert. (freidhof) 
# 04.10.95 Neue Version geht in den Testbetrieb (freidhof)

# Adresse fuer Sendebericht ermitteln
BACK=`/usr/local/etc/get_address`

# Zaehler fuer Anzahl der Parameter setzen
typeset -i PARAMETERS 
let PARAMETERS=$#

STARTSEQ=""

while [ $PARAMETERS -gt 1 ]
do
  STARTSEQ="$STARTSEQ $1"
  shift 1
  let PARAMETERS=PARAMETERS-1
done

# Logfile ueberpruefen und, falls nicht vorhanden, erzeugen.
LOGFILE=/var/tmp/fax.log

if [ -a $LOGFILE ]; then
  /bin/touch $LOGFILE
  /bin/chmod 600 $LOGFILE
fi

# Zwischenspeicher finden (trickreich und sicher)
TMPFILE="/tmp/fax_$RANDOM"
while [ "`/bin/echo $TMPFILE*`" != "$TMPFILE*" ]
do
  TMPFILE="/tmp/fax_$RANDOM"
done

# Name des Files mit der Rueckmeldung und Initialisierung
MESSAGEFILE=$TMPFILE.mail
echo "Hallo!\n" > $TMPFILE.mail
echo "Hier ist der Bericht von Ihrem Fax:" >> $TMPFILE.mail

# Erste Eintragung in das Logfile
/bin/echo "--------------------------" >> $LOGFILE
/bin/echo " Name: "$BACK >> $LOGFILE
/bin/echo " Date: "`/bin/date` >> $LOGFILE

# Name des Druckfiles in Warteschlange speichern
FILE=$1

# Fehlervariable
ERROR=false

# Telefon-Nummer extrahieren
/bin/echo "1.) Telefon-Nr. und Aufloesung feststellen"  >> $TMPFILE.mail
NUMBER=`head -1 $FILE| awk '{if ($1 != "Number:")
                               print "ERROR";
                             else
                               print $2}'`
                               
# Resolution extrahieren
RESOLUTION=`head -1 $FILE| awk '{if ($3 != "Resolution:")
                                   print "ERROR";
                                 else
                                   if ($4 == "High")
                                     print "HIGH";
                                   else
                                     if ($4 == "Low")
                                       print "LOW";
                                     else
                                       print "LOW"}'`

# Fehlerueberpruefung
if [ "$RESOLUTION" = "ERROR" -o "$NUMBER" = "ERROR" ]
then                                      
  ERROR=true
  /bin/echo "    Bei der Ermittlung der Telefon-Nr. und der Aufloesung" >> $TMPFILE.mail
  /bin/echo "    ist es zu einem Fehler gekommen. Der Fehler wurde an den" >> $TMPFILE.mail
  /bin/echo "    Adminstrator weitergeleitet." >> $TMPFILE.mail
  
  # Mail an freidhof, da dieser Fehler eigentlich nicht auftreten kann. 
  echo "Please check the fax log-file on hades. Impossible error detected.\nDate: "`/bin/date`\
   | mail -s "Possible attack to fax" freidhof@zeus
   
  /bin/echo " Error(!): Couldn't detect phonenumber or resolution!" >> $LOGFILE
  /bin/echo " Phone-Nr. : "$NUMBER >> $LOGFILE
  /bin/echo " Resolution: "$RESOLUTION >> $LOGFILE  
else
  /bin/echo "    Keine Fehler bei der Ermittlung der Telefon-Nr. und der Aufloesung." >> $TMPFILE.mail
  /bin/echo "    Telefon-Nr.: "$NUMBER >> $TMPFILE.mail
  /bin/echo "    Aufloesung : "$RESOLUTION >> $TMPFILE.mail

  /bin/echo " Phone-Nr. : "$NUMBER >> $LOGFILE
  /bin/echo " Resolution: "$RESOLUTION >> $LOGFILE  
fi  
  
if [ "$ERROR" = "false" ]
then
  # Erste Zeile mit den Informationen ueber Nummer und Aufloesung loeschen
  /bin/cat $FILE | /bin/sed '1d' > $TMPFILE

  # PS-File konvertieren
  /bin/echo "2.) PS-File in Fax-Format wandeln"  >> $TMPFILE.mail  
  if [ "$RESOLUTION" = "HIGH" ] 
  then
    /usr/local/bin/gs -dSAFER -sDEVICE=dfaxhigh -sOutputFile=$TMPFILE-%03d.fax -sNOPAUSE $TMPFILE quit.ps > $TMPFILE.gs
    # gs-Umwandlung ueberpruefen
    if [ ! "`cat $TMPFILE.gs | grep Error:`" = "" -o ! -r $TMPFILE-001.fax ]
    then
      ERROR=true
      /bin/echo "    Fehler bei Umwandlung des Postscript-Files! Abbruch!"  >> $TMPFILE.mail
      /bin/echo " Error(!): Couldn't convert PS-file to fax-format!" >> $LOGFILE
    else
      /bin/echo "    Kein Fehler bei Konvertierung des Postscript-Files."  >> $TMPFILE.mail
      /bin/echo " Converting PS to fax OK." >> $LOGFILE
    fi
  else
    /usr/local/bin/gs -dSAFER -sDEVICE=dfaxlow -sOutputFile=$TMPFILE-%03d.fax -sNOPAUSE $TMPFILE quit.ps > $TMPFILE.gs
    # gs-Umwandlung ueberpruefen
    if [ ! "`cat $TMPFILE.gs | grep Error:`" = "" -o ! -r $TMPFILE-001.fax ]
    then
      ERROR=true
      /bin/echo "    Fehler bei Umwandlung des Postscript-Files! Abbruch!"  >> $TMPFILE.mail
      /bin/echo " Error(!): Couldn't convert PS-file to fax-format!" >> $LOGFILE
    else
      /bin/echo "    Kein Fehler bei Konvertierung des Postscript-Files."  >> $TMPFILE.mail
      /bin/echo " Converting PS to fax OK." >> $LOGFILE
    fi
  fi 
  
  if [ "$ERROR" = "false" ]
  then
  
    # Fax senden
    /bin/echo "3.) Fax versenden"  >> $TMPFILE.mail 
    if [ "$RESOLUTION" = "HIGH" ] 
    then
      /usr/local/bin/sendfax -v $NUMBER $TMPFILE-*.fax > $TMPFILE.stdout 2> $TMPFILE.stderr
    else
      /usr/local/bin/sendfax -v -n $NUMBER $TMPFILE-*.fax > $TMPFILE.stdout 2> $TMPFILE.stderr
    fi 

    # Analyse der sendfax-Ausgabe
    # 1. Hat die Kontaktaufnahme funktioniert?
    if [ "`cat $TMPFILE.stdout | grep Dialing | grep OK.`" = "" ]
    then
      ERROR=true
      /bin/echo "    Bei dem Waehlen ist ein Fehler aufgetreten. Mogliche Ursachen:" >> $TMPFILE.mail
      /bin/echo "      a) Zielnummer war besetzt." >> $TMPFILE.mail
      /bin/echo "      b) Zielnummer war kein Faxgeraet." >> $TMPFILE.mail
      /bin/echo "      c) Bei der Zielnummer wurde nicht abgehoben." >> $TMPFILE.mail 
      /bin/echo " Error(!): Connection failed!" >> $LOGFILE
    else
      /bin/echo "    Zielfax wurde erfolgreich kontaktiert." >> $TMPFILE.mail
      /bin/echo " Fax connected." >> $LOGFILE
      
      # 2. Wurden alle Seiten gesendet? (not in circuit tested)
      let pages=0  
      let send=0 
      for i in $TMPFILE-*.fax 
      do 
        let pages=pages+1
        if [ "`cat $TMPFILE.stdout | grep $i`" = "sending '$i'..." ] 
        then 
          let send=send+1
        fi
      done
      if [ $pages -ne $send ]
      then 
        ERROR=true
        /bin/echo "    Fehler! Es wurden nur "$send" von "$pages" versendet." >> $TMPFILE.mail
        /bin/echo " Error(!): Only "$send" from "$pages" are sent." >> $LOGFILE
      else
        if [ $pages -eq 1 ]
        then 
          /bin/echo "    Es wurde "$pages" Seite versendet." >> $TMPFILE.mail
          /bin/echo " "$pages" page is sent." >> $LOGFILE
        else
          /bin/echo "    Es wurden "$pages" Seiten versendet." >> $TMPFILE.mail
          /bin/echo " "$pages" pages are sent." >> $LOGFILE
        fi                
      fi
    fi      
  fi
fi

# Verschicken der Mail
if [ "$ERROR" = "false" ]
then 
  /bin/echo "\nBei dem Versenden wurde kein Fehler festgestellt." >> $TMPFILE.mail
  /bin/echo "Bitte ueberpruefen sie trotzdem den folgenden Sendebericht.\n" >> $TMPFILE.mail
  /bin/echo "Sendebericht von sendfax:" >> $TMPFILE.mail
  /bin/cat $TMPFILE.stdout $TMPFILE.stderr >> $TMPFILE.mail
  /bin/cat $TMPFILE.mail | /bin/mail -s "Fax OK!" $BACK
else
  /bin/echo "\nAchtung! Leider sind Fehler aufgetreten und das Fax konnte" >> $TMPFILE.mail
  /bin/echo "nicht gesendet werden.\n" >> $TMPFILE.mail
  if [ -r "$TMPFILE.stdout" ]
  then 
    /bin/echo "Sendebericht von sendfax:" >> $TMPFILE.mail
    /bin/cat $TMPFILE.stdout $TMPFILE.stderr >> $TMPFILE.mail
  fi
  /bin/cat $TMPFILE.mail | /bin/mail -s "Fax FEHLER!" $BACK 
fi

# Loeschen der temporaeren Files
/bin/rm -f $TMPFILE*
