/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Items_H
#include "Items.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef IconInfo_H
#include "IconInfo.h"
#endif

#ifndef Timeout_H
#include "Timeout.h"
#endif


static map<string,Items*> items;

class MakeItems : public Timeout {

	map<string,Items*>::iterator* j_;

public:
	MakeItems() : Timeout(10),  j_(0)  { enable(); }


	virtual void run() 
	{
		if(j_ == 0) {
			j_  = new map<string,Items*>::iterator();
			*j_ = items.begin();
		}

		if((*j_) == items.end())
			disable();
		else {
			Items::find((*(*j_)).first);
			(*j_)++;
		}
	}
};


Items::Items(request* r):
	r_(r),
	object_(0)
{
	static MakeItems maker;
	items[get_value(r,"name",0)] = this;
}

Items::~Items()
{
	// Not called
}

IconObject* Items::find(const string& a)
{
	// cout << "Items::find( " << a << endl;
	map<string,Items*>::iterator j = items.find(a);
	if(j == items.end())
		return 0;
	else
		return (*j).second->object();
}

void Items::load(request* r)
{
	new Items(r);
}

IconObject* Items::object()
{
	if(object_ != 0)
		return object_;

	const char *kind = get_value(r_,"class",0);
	const char *full = get_value(r_,"full_name",0);
	const char *x    = get_value(r_,"x",0);
	const char *y    = get_value(r_,"y",0);
	const char *link = get_value(r_,"linked_to",0);

	object_ = IconObject::search(full); 
	if(object_) return object_;

	if(link)
	{
		Path path = Folder::top()->path();
		path = path.add(full);
		path.symlink(string(link));
	}

	object_ = IconFactory::create(full,IconClass::find(kind));
	if(object_) {
		if(x && y) object_->parent()->position(object_,atol(x),atol(y));
		return object_;
	}

	Log::error(0) << "Cannot create " << full << endl;
	return 0;
}

// Because the system folders are not created properly
// We need to fix them

void Items::fix(IconObject* o)
{
	if(o->parent() == 0) return;
		
	string n = o->fullName();
	string c = o->className();

	for(map<string,Items*>::iterator j = items.begin(); j != items.end(); ++j)
	{
		const char *full = get_value((*j).second->r_,"full_name",0);
		const char *kind = get_value((*j).second->r_,"class",0);

		if(n == full && !(c == kind))
		{
			// Log::error(o) << "Class is " << c << " and should be " << kind << endl;

			IconInfo& info = o->info();
			info.fix(kind);
			o->saveInfo();

		}
	}
}

static SimpleLoader<Items> loadClasses("interface_item",1);
