/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Editor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Editor_H
#define Editor_H


#include <string>
using std::string;
#include <Xm/Xm.h>

#ifndef DropSite_H
#include "DropSite.h"
#endif

#include "UIEditor.h"

class IconObject;
class IconClass;
class EditorDrawer;
class EditorTool;
class EditorObserver;

#include "IconObject.h"

class Editor {
public:

// -- Exceptions
	// None

// -- Destructor

	virtual ~Editor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	const IconClass& iconClass();
	const string&    kind();
	IconObject*      current();
	void             observer(EditorObserver*);

	void             edit(IconObject*);
	void             done();

	void   notifyObserverApply();
	void   notifyObserverClose();

	virtual void empty();
	virtual void temporary();
	virtual string alternateEditor();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static void open(IconObject*);

protected:

// -- Contructors

	Editor(const IconClass&,const string& kind);


// -- Members
	// None

	const IconClass&    class_;
	string              kind_;
	EditorObserver*     observer_;
	IconObjectH         current_;
	bool                temporary_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Editor(const Editor&);
	Editor& operator=(const Editor&);

// -- Members

	virtual void edit();
	virtual void raise();

// -- Methods


// -- Friends

	//friend ostream& operator<<(ostream& s,const Editor& p)
	//	{ p.print(s); return s; }

};


#endif
