/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQIconHolder_H
#define MvQIconHolder_H

#include <QAbstractItemModel>
#include <QListView>
#include <QString>

#include "IconObject.h"

#include <vector>

using namespace std;

class  Parameter;
class  Request;
class  RequestPanelItem;

class MvQIconHolderModel : public QAbstractItemModel
{
public:
    	MvQIconHolderModel(const vector<string>&,QObject *parent=0);  
  
	int columnCount( const QModelIndex&) const;
	int rowCount (const QModelIndex& parent = QModelIndex() ) const;
	QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;
	
	void setIcons(const vector<IconObjectH>&);
	void clearIcons(const vector<IconObjectH>&);
	void add(IconObjectH);
	void remove(IconObjectH);
	bool accept(IconObjectH);
	IconObject* iconObject(const QModelIndex&);
	void iconObjects(vector<IconObjectH>&);

protected:
    	QList<IconObjectH> icons_;
	vector<string> classes_;
};	


class MvQIconHolderView : public QListView
{
Q_OBJECT
  
public:
	MvQIconHolderView(MvQIconHolderModel*,RequestPanelItem*,QWidget *parent=0);
	~MvQIconHolderView();
	
public slots:
    	void slotDoubleClickItem(const QModelIndex& index);
    	void slotContextMenu(const QPoint &);
 
signals:
    	void edited();
	void iconDropped(QString);

protected:
	void remove(IconObjectH);
	void command(QString,IconObjectH);
	
	void dragEnterEvent(QDragEnterEvent *);
	void dragMoveEvent(QDragMoveEvent *);
	void dropEvent(QDropEvent *);

	MvQIconHolderModel* model_;
	vector<string> classes_;
	RequestPanelItem* owner_;
};	
	

#endif
