# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_volume_mapper import AbstractVolumeMapper


class VolumeMapper(AbstractVolumeMapper):
    r"""
    VolumeMapper - Abstract class for a volume mapper
    
    Superclass: AbstractVolumeMapper
    
    VolumeMapper is the abstract definition of a volume mapper for
    regular rectilinear data (vtkimage_data). Several basic types of
    volume mappers are supported.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVolumeMapper, obj, update, **traits)
    
    compute_normal_from_opacity = tvtk_base.false_bool_trait(desc=\
        r"""
        If enabled, the volume(s) whose shading is enabled will use the
        gradient of opacity instead of the scalar gradient to estimate
        the surface's normal when applying the shading model. The opacity
        considered for the gradient is then the scalars converted to
        opacity by the transfer function(s). For now it is only supported
        in GPUVolumeRayCastMapper. In SmartVolumeMapper and in
        MultiBlockVolumeMapper, this parameter is used when the GPU
        mapper is effectively used. Note that enabling it might affect
        performances, especially when using a 2D TF or a gradient
        opacity. It is disabled by default.
        """
    )

    def _compute_normal_from_opacity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormalFromOpacity,
                        self.compute_normal_from_opacity_)

    cropping = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn On/Off orthogonal cropping. (Clipping planes are
        perpendicular to the coordinate axes.)
        """
    )

    def _cropping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCropping,
                        self.cropping_)

    blend_mode = tvtk_base.RevPrefixMap({'composite': 0, 'additive': 4, 'average_intensity': 3, 'iso_surface': 5, 'maximum_intensity': 1, 'minimum_intensity': 2, 'slice': 6}, default_value='composite', desc=\
        r"""
        Set/Get the blend mode. The default mode is Composite where the
        scalar values are sampled through the volume and composited in a
        front-to-back scheme through alpha blending. The final color and
        opacity is determined using the color and opacity transfer
        functions.
        
        Maximum and minimum intensity blend modes use the maximum and
        minimum scalar values, respectively, along the sampling ray. The
        final color and opacity is determined by passing the resultant
        value through the color and opacity transfer functions.
        
        Additive blend mode accumulates scalar values by passing each
        value through the opacity transfer function and then adding up
        the product of the value and its opacity. In other words, the
        scalar values are scaled using the opacity transfer function and
        summed to derive the final color. Note that the resulting image
        is always grayscale i.e. aggregated values are not passed through
        the color transfer function. This is because the final value is a
        derived value and not a real data value along the sampling ray.
        
        Average intensity blend mode works similar to the additive blend
        mode where the scalar values are multiplied by opacity calculated
        from the opacity transfer function and then added. The additional
        step here is to divide the sum by the number of samples taken
        through the volume. One can control the scalar range by setting
        the average_ip_scalar_range ivar to disregard scalar values, not in
        the range of interest, from the average computation. As is the
        case with the additive intensity projection, the final image will
        always be grayscale i.e. the aggregated values are not passed
        through the color transfer function. This is because the
        resultant value is a derived value and not a real data value
        along the sampling ray.
        
        iso_surface blend mode uses contour values defined by the user in
        order to display scalar values only when the ray crosses the
        contour. It supports opacity the  ...
         [Truncated]
        """
    )

    def _blend_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBlendMode,
                        self.blend_mode_)

    cropping_region_flags = tvtk_base.RevPrefixMap({'sub_volume': 8192, 'cross': 4289552, 'fence': 49020602, 'inverted_cross': 129928175, 'inverted_fence': 85197125}, default_value='sub_volume', desc=\
        r"""
        Set the flags for the cropping regions. The clipping planes
        divide the volume into 27 regions - there is one bit for each
        region. The regions start from the one containing voxel (0,0,0),
        moving along the x axis fastest, the y axis next, and the z axis
        slowest. These are represented from the lowest bit to bit number
        27 in the integer containing the flags. There are several
        convenience functions to set some common configurations -
        subvolume (the default), fence (between any of the clip plane
        pairs), inverted fence, cross (between any two of the clip plane
        pairs) and inverted cross.
        """
    )

    def _cropping_region_flags_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCroppingRegionFlags,
                        self.cropping_region_flags_)

    average_ip_scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(-9.999999680285692e+37, 9.999999680285692e+37), cols=2, desc=\
        r"""
        Set/Get the scalar range to be considered for average intensity
        projection blend mode. Only scalar values between this range will
        be averaged during ray casting. This can be useful when volume
        rendering CT datasets where the areas occupied by air would
        deviate the final rendering. By default, the range is set to
        (VTK_FLOAT_MIN, VTK_FLOAT_MAX).
        \sa set_blend_mode_to_average_intensity()
        """
    )

    def _average_ip_scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAverageIPScalarRange,
                        self.average_ip_scalar_range)

    cropping_region_planes = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the Cropping Region Planes ( xmin, xmax, ymin, ymax,
        zmin, zmax ) These planes are defined in volume coordinates -
        spacing and origin are considered.
        """
    )

    def _cropping_region_planes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCroppingRegionPlanes,
                        self.cropping_region_planes)

    def _get_cropping_max_value(self):
        return self._vtk_obj.GetCroppingMaxValue()
    cropping_max_value = traits.Property(_get_cropping_max_value, desc=\
        r"""
        
        """
    )

    def _get_cropping_min_value(self):
        return self._vtk_obj.GetCroppingMinValue()
    cropping_min_value = traits.Property(_get_cropping_min_value, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataSet
        C++: virtual DataSet *get_input()
        get_input(self, port:int) -> DataSet
        C++: virtual DataSet *get_input(const int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_voxel_cropping_region_planes(self):
        return self._vtk_obj.GetVoxelCroppingRegionPlanes()
    voxel_cropping_region_planes = traits.Property(_get_voxel_cropping_region_planes, desc=\
        r"""
        Get the cropping region planes in voxels. Only valid during the
        rendering process
        """
    )

    def set_input_data(self, *args):
        """
        set_input_data(self, __a:ImageData) -> None
        C++: virtual void set_input_data(ImageData *)
        set_input_data(self, __a:DataSet) -> None
        C++: virtual void set_input_data(DataSet *)
        set_input_data(self, __a:RectilinearGrid) -> None
        C++: virtual void set_input_data(RectilinearGrid *)
        Set/Get the input data
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    _updateable_traits_ = \
    (('compute_normal_from_opacity', 'GetComputeNormalFromOpacity'),
    ('cropping', 'GetCropping'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('blend_mode',
    'GetBlendMode'), ('cropping_region_flags', 'GetCroppingRegionFlags'),
    ('scalar_mode', 'GetScalarMode'), ('average_ip_scalar_range',
    'GetAverageIPScalarRange'), ('cropping_region_planes',
    'GetCroppingRegionPlanes'), ('array_access_mode',
    'GetArrayAccessMode'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normal_from_opacity', 'cropping', 'debug',
    'global_warning_display', 'release_data_flag', 'blend_mode',
    'cropping_region_flags', 'scalar_mode', 'array_access_mode',
    'average_ip_scalar_range', 'cropping_region_planes', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VolumeMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normal_from_opacity', 'cropping'], ['blend_mode',
            'cropping_region_flags', 'scalar_mode'], ['array_access_mode',
            'average_ip_scalar_range', 'cropping_region_planes', 'object_name']),
            title='Edit VolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

