# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SphericalPointIterator(Object):
    r"""
    SphericalPointIterator - Traverse a collection of points in
    spherical ordering.
    
    Superclass: Object
    
    SphericalPointIterator is a state-based iterator for traversing a
    set of points (i.e., a neighborhood of points) in a dataset,
    providing a point traversal order across user-defined "axes" which
    span a 2D or 3D space (typically a circle or sphere). The points
    along each axes may be sorted in increasing radial order. To define
    the points, specify a dataset (i.e., its associated points, whether
    the points are represented implicitly or explicitly) and an
    associated neighborhood over which to iterate. Methods for iterating
    over the points are provided.
    
    For example, consider the axes of iteration to be the four rays
    emanating from the center of a square and passing through the center
    of each of the four edges of the square. Points to be iterated over
    are associated (using a dot product) with each of the four axes, and
    then can be sorted along each axis. Then the order of iteration is
    then: (axis0,pt0), (axis1,pt0), (axis2,pt0), (axis3,pt0),
    (axis0,pt1), (axis1,pt1), (axis2,pt1), (axis3,pt1), (axis0,pt2),
    (axis1,pt2), (axis2,pt2), (axis3,pt2), and so on in a "spiraling"
    fashion until all points are visited. Thus the order of visitation
    is: iteration i visits all N axes in order, returning the jth point
    sorted along each of the N axes (i.e., i increases the fastest).
    Alternatively, methods exist to randomly access points, or points
    associated with an axes, so that custom iteration methods can be
    defined.
    
    The iterator can be defined with any number of axes (defined by 3D
    vectors). The axes must not be coincident, and typically are equally
    spaced from one another. The order which the axes are defined
    determines the order in which the axes (and hence the points) are
    traversed. So for example, in a 2D sphere, four axes in the
    (-x,+x,-y,+y) directions would provide a "ping pong" iteration, while
    four axes ordered in the (+x,+y,-x,-y) directions would provide a
    counterclockwise rotation iteration.
    
    The iterator provides thread-safe iteration of dataset points. It
    supports both random and forward iteration.
    
    @warning
    The behavior of the iterator depends on the ordering of the iteration
    axes. It is possible to obtain a wide variety of iteration patterns
    depending on these axes. For example, if only one axis is defined,
    then a "linear" pattern is possible (i.e., visiting points in the
    half space defined by the vector); if two axes, then a "diagonal"
    iteration pattern; and so on. Note that points are sorted along the
    iteration axes depending on the their projection onto them (e.g.,
    using the dot product). Because only points with positive projection
    are associated with an axis, it is possible that some points in the
    neighborhood will not be processed (i.e., if a point in the
    neighborhood does not positively project onto any of the axes, then
    it will not be iterated over). Thus if all points are to be iterated
    over, then the axes must form a basis which covers all points using
    positive projections.
    
    @sa
    Voronoi2D Voronoi3D StaticPointLocator PointLocator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSphericalPointIterator, obj, update, **traits)
    
    def _get_axes(self):
        return wrap_vtk(self._vtk_obj.GetAxes())
    def _set_axes(self, arg):
        old_val = self._get_axes()
        my_arg = deref_array([arg], [['vtkDoubleArray'], ('int', 'int')])
        self._wrap_call(self._vtk_obj.SetAxes,
                        my_arg[0])
        self.trait_property_changed('axes', old_val, arg)
    axes = traits.Property(_get_axes, _set_axes, desc=\
        r"""
        
        """
    )

    def _get_data_set(self):
        return wrap_vtk(self._vtk_obj.GetDataSet())
    def _set_data_set(self, arg):
        old_val = self._get_data_set()
        self._wrap_call(self._vtk_obj.SetDataSet,
                        deref_vtk(arg))
        self.trait_property_changed('data_set', old_val, arg)
    data_set = traits.Property(_get_data_set, _set_data_set, desc=\
        r"""
        
        """
    )

    sorting = traits.Trait(0, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        r"""
        Specify whether points along each axis are radially sorted, and
        if so, whether in an ascending or descending direction. (Note
        that some operators such as the locator query
        find_closest_n_points() return radially sorted neighborhoods in
        ascending direction and often do not need sorting - this can save
        significant time.)
        """
    )

    def _sorting_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSorting,
                        self.sorting)

    def get_axis_points(self, *args):
        """
        get_axis_points(self, axis:int, npts:int, pts:(int, ...)) -> None
        C++: void get_axis_points(int axis, IdType &npts,
            const IdType *&pts)
        Return the list of points along the specified ith axis.
        """
        ret = self._wrap_call(self._vtk_obj.GetAxisPoints, *args)
        return ret

    def _get_current_point(self):
        return self._vtk_obj.GetCurrentPoint()
    current_point = traits.Property(_get_current_point, desc=\
        r"""
        Get the current point (point id and coordinates) during forward
        iteration.
        """
    )

    def get_current_point(self, *args):
        """
        get_current_point(self, ptId:int, x:[float, float, float]) -> None
        C++: void get_current_point(IdType &ptId, double x[3])
        get_current_point(self) -> int
        C++: IdType get_current_point()
        Get the current point (point id and coordinates) during forward
        iteration.
        """
        ret = self._wrap_call(self._vtk_obj.GetCurrentPoint, *args)
        return ret

    def _get_number_of_axes(self):
        return self._vtk_obj.GetNumberOfAxes()
    number_of_axes = traits.Property(_get_number_of_axes, desc=\
        r"""
        Return the number of axes defined. The value returned is valid
        only after Initialize() is invoked.
        """
    )

    def get_point(self, *args):
        """
        get_point(self, axis:int, ptIdx:int) -> int
        C++: IdType get_point(int axis, int ptIdx)
        Provide random access to the jth point of the ith axis. Returns
        the point id located at (axis,ptIdx); or a value <0 if the
        requested point does not exist.
        """
        ret = self._wrap_call(self._vtk_obj.GetPoint, *args)
        return ret

    def build_representation(self, *args):
        """
        build_representation(self, pd:PolyData) -> None
        C++: void build_representation(PolyData *pd)
        A convenience method that produces a geometric representation of
        the iterator (e.g., axes + center). The representation simply
        draws lines for each of the axes emanating from the center point.
        Each line (or line cell) is assigned cell data which is the axis
        number. This is typically used for debugging or educational
        purposes. Note that the method is valid only after Initialize()
        has been invoked.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BuildRepresentation, *my_args)
        return ret

    def go_to_first_point(self):
        """
        go_to_first_point(self) -> None
        C++: void go_to_first_point()
        Begin iterating over the neighborhood of points. It is possible
        that not all points are iterated over - those points not
        projecting onto any axis with a positive dot product are not
        visited.
        """
        ret = self._vtk_obj.GoToFirstPoint()
        return ret
        

    def go_to_next_point(self):
        """
        go_to_next_point(self) -> None
        C++: void go_to_next_point()
        Go to the next point in the neighborhood. This is only valid when
        is_done_with_traversal() returns false;
        """
        ret = self._vtk_obj.GoToNextPoint()
        return ret
        

    def initialize(self, *args):
        """
        initialize(self, center:[float, float, float],
            neighborhood:IdList) -> bool
        C++: bool initialize(double center[3], IdList *neighborhood)
        initialize(self, center:[float, float, float], numNei:int,
            neighborhood:[int, ...]) -> bool
        C++: bool initialize(double center[3], IdType numNei,
            IdType *neighborhood)
        initialize(self, center:[float, float, float]) -> bool
        C++: bool initialize(double center[3])
        Initialize the iteration process around a position [x], over a
        set of points (the neighborhood) defined by a list of numNei
        point ids. (The point ids refer to the points contained in the
        dataset.) If initialization fails (because the Axes or the
        data_set have not been defined) then false is returned; true
        otherwise. One of the Initialize() variants enables iteration
        over all points in the dataset.
        """
        my_args = deref_array(args, [(['float', 'float', 'float'], 'vtkIdList'), (['float', 'float', 'float'], 'int', ['int', Ellipsis]), (['float', 'float', 'float'],)])
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def is_done_with_traversal(self):
        """
        is_done_with_traversal(self) -> bool
        C++: bool is_done_with_traversal()
        Return true if set traversal is completed. Otherwise false.
        """
        ret = self._vtk_obj.IsDoneWithTraversal()
        return ret
        

    def set_sort_type_to_ascending(self):
        """
        set_sort_type_to_ascending(self) -> None
        C++: void set_sort_type_to_ascending()"""
        ret = self._vtk_obj.SetSortTypeToAscending()
        return ret
        

    def set_sort_type_to_descending(self):
        """
        set_sort_type_to_descending(self) -> None
        C++: void set_sort_type_to_descending()"""
        ret = self._vtk_obj.SetSortTypeToDescending()
        return ret
        

    def set_sort_type_to_none(self):
        """
        set_sort_type_to_none(self) -> None
        C++: void set_sort_type_to_none()"""
        ret = self._vtk_obj.SetSortTypeToNone()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('sorting', 'GetSorting'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name', 'sorting'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SphericalPointIterator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SphericalPointIterator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'sorting']),
            title='Edit SphericalPointIterator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SphericalPointIterator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

