/***********************************************************************************

    Copyright (C) 2010 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_PREFERENCES_HEADER
#define LIFEOGRAPH_DIALOG_PREFERENCES_HEADER


#include <gtkmm.h>

#include "diary.hpp"
#include "lifeograph.hpp"


namespace LIFEO
{


class DialogPreferences : public DialogEvent
{
    public:
        static void                 create();
                                    DialogPreferences( BaseObjectType*,
                                                       const Glib::RefPtr< Gtk::Builder >& );
        void                        handle_response( int );
        void                        handle_ChB_autologout_toggled();
        void                        handle_ChB_ftoolbar_toggled();
        void                        update_date_format();

    protected:
        static DialogPreferences*
                                    ptr;
        Gtk::CheckButton*           m_ChB_autologout;
        Gtk::Box*                   m_Bx_max_idle_time;
        Gtk::SpinButton*            m_SpB_max_idle_time;
        Gtk::ComboBoxText*          m_CB_date_order;
        Gtk::ComboBoxText*          m_CB_date_separator;
        Gtk::CheckButton*           m_ChB_formatting_toolbar;
        Gtk::CheckButton*           m_ChB_use_dark_theme;

    private:

};

} // end of namespace LIFEO

#endif

