/*
 *  Copyright 1994-2014 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"
#include "pictures.h"


u_long id = 949094845;
u_long options = BE_GFX|BEQ_PICTURE;
char dname[] = "Y Scanline";
char desc[] = "Vertical scanline";


#define MINPCT 0.01
#define DPCT   0.002

/* conf */
typedef struct {
  float size;          /* line is %of screen HEIGHT */
  char dir;            /* -1 or +1 */
  u_char ping_pong;    /* bounce */
} yscanline_conf;

static yscanline_conf yscanline_cf;


void
create(__attribute__ ((unused)) Context_t *ctx)
{
  if (pictures == NULL)
    options |= BEQ_DISABLED;
  else {
    yscanline_cf.size = MINPCT;
    yscanline_cf.dir = 1;
    yscanline_cf.ping_pong = 0;
  }
}


void
on_switch_on(__attribute__ ((unused)) Context_t *ctx)
{
  yscanline_cf.dir = (b_rand_boolean()) ? -1 : 1;
  yscanline_cf.ping_pong = b_rand_boolean();
}


static void
y_scanline(Context_t *ctx, float amount)
{
  u_short s, size = amount * HEIGHT; /* number of rows */
  u_short i;
  static int y_line = 0;
  Buffer8_t *dst = NULL;
  PictFader_t *pf = ctx->pf;
  Buffer8_t *src = pf->cur->buff;

  swap_buffers(ctx);
  dst = passive_buffer(ctx);

  for (s = 0; s < size; s++) {
    for (i = 0; i <= MAXX; i++)
      set_pixel_nc(dst, i, y_line, get_pixel_nc(src, i, y_line));
		
    y_line += yscanline_cf.dir;
    if (y_line > MAXY) {
      if (yscanline_cf.ping_pong) {
	y_line = MAXY;
	yscanline_cf.dir = -yscanline_cf.dir;
      } else
	y_line = 0;
    } else
      if (y_line < 0) {
	if (yscanline_cf.ping_pong) {
	  y_line = 0;
	  yscanline_cf.dir = -yscanline_cf.dir;
	} else
	  y_line = MAXY;
      }
  }
}


void
run(Context_t *ctx)
{
  if (pictures != NULL)
    y_scanline(ctx, yscanline_cf.size);
}


#ifndef EVT_DAWA
#if HAVE_SDL_H
u_char
on_SDL_Event(Context_t *ctx, const SDL_Event *e)
{
  if (key(e, SDLK_KP_PLUS)) {
    if (yscanline_cf.size < 1.0)
      yscanline_cf.size += DPCT;
    printf ("::: yscanline (%f)\n", yscanline_cf.size);
    return 1;
  } else if (key(e, SDLK_KP_MINUS)) {
    if (yscanline_cf.size > MINPCT)
      yscanline_cf.size -= DPCT;
    printf ("::: yscanline (%f)\n", yscanline_cf.size);
    return 1;
  } else if (key(e, SDLK_r)) {
    yscanline_cf.ping_pong = !yscanline_cf.ping_pong;
    printf ("::: yscanline ping pong (%d)\n", yscanline_cf.ping_pong);
    return 1;
  }
  
  return 0;
}
#endif /* HAVE_SDL_H */
#endif /* !EVT_DAWA */

