/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef ADDNETWORKROUTEDIALOG_H
#define ADDNETWORKROUTEDIALOG_H

#include <QtCore/QString>

#include <kdialog.h>

#include "ui_addnetworkroutedialogbase4.h"

class AddNetworkRouteDialog : public KDialog, public Ui_AddNetworkRouteDialogBase
{
    Q_OBJECT

public:
    AddNetworkRouteDialog(QWidget *parent, const QString& caption);
    ~AddNetworkRouteDialog();

    QString getNetwork();
    QString getNetmask();
    QString getGateway();
    QString getInterface();
    bool getUseGateway();
    bool getUseInterface();
    bool dialogModified;

public Q_SLOTS:
    void accept();
    void useGatewayToggled(bool);
    void useInterfaceToggled(bool);

private:
    QString Network;
    QString Netmask;
    QString Gateway;
    QString Interface;
    bool useGateway;
    bool useInterface;

private slots:
    void dialogChanged();

signals:
    void changed();
};

#endif
