/*
 * kover - Kover is an easy to use WYSIWYG CD cover printer with CDDB support.
 * Copyright (C) 2001, 2008 by Adrian Reber
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cddb_211_item.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

cddb_211_item::cddb_211_item()
{
	cddb_data = NULL;
}

cddb_211_item::cddb_211_item(char *input)
{
	cddb_data = strdup(input);
}

cddb_211_item::cddb_211_item(string input)
{
	cddb_data = strdup(input.c_str());
}

cddb_211_item::~cddb_211_item()
{
	if (cddb_data)
		free(cddb_data);
}

char *
cddb_211_item::get()
{
	return strdup(cddb_data);
}

void
cddb_211_item::set_title(string input)
{
	title = input;
}
void
cddb_211_item::set_artist(string input)
{
	artist = input;
}
void
cddb_211_item::set_category(string input)
{
	category = input;
}
void
cddb_211_item::set_id(unsigned long input)
{
	id = input;
}
string
cddb_211_item::get_title()
{
	return title;
}
string
cddb_211_item::get_artist()
{
	return artist;
}
string
cddb_211_item::get_category()
{
	return category;
}
unsigned long
cddb_211_item::get_id()
{
	return id;
}
