/*
  Copyright (c) 2016-2019 Montel Laurent <montel@kde.org>
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
/* ============================================================
* QupZilla - WebKit based browser
* Copyright (C) 2010-2014  David Rosca <nowrep@gmail.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
* ============================================================ */
/**
 * Copyright (c) 2009, Benjamin C. Meyer <ben@meyerhome.net>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Benjamin Meyer nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef ADBLOCKSUBSCRIPTION_H
#define ADBLOCKSUBSCRIPTION_H

#include <QVector>
#include <QUrl>

#include "adblockrule.h"
#include "adblocksearchtree.h"

class QNetworkAccessManager;
class QUrl;
class QNetworkReply;
namespace AdBlock {
class AdBlockSubscription : public QObject
{
    Q_OBJECT
public:
    explicit AdBlockSubscription(const QString &title, QObject *parent = nullptr);
    ~AdBlockSubscription();

    Q_REQUIRED_RESULT QString title() const;

    Q_REQUIRED_RESULT QString filePath() const;
    void setFilePath(const QString &path);

    Q_REQUIRED_RESULT QUrl url() const;
    void setUrl(const QUrl &url);

    virtual void loadSubscription(const QStringList &disabledRules);
    virtual void saveSubscription();

    const AdBlockRule *rule(int offset) const;
    QVector<AdBlockRule *> allRules() const;

    const AdBlockRule *enableRule(int offset);
    const AdBlockRule *disableRule(int offset);

    virtual Q_REQUIRED_RESULT bool canEditRules() const;
    virtual Q_REQUIRED_RESULT bool canBeRemoved() const;

    virtual Q_REQUIRED_RESULT int addRule(AdBlockRule *rule);
    virtual Q_REQUIRED_RESULT bool removeRule(int offset);
    virtual const AdBlockRule *replaceRule(AdBlockRule *rule, int offset);

    Q_REQUIRED_RESULT bool enabled() const;
    void setEnabled(bool enabled);

public Q_SLOTS:
    void updateSubscription();

Q_SIGNALS:
    void subscriptionChanged();
    void subscriptionUpdated();
    void subscriptionError(const QString &message);

protected Q_SLOTS:
    void subscriptionDownloaded();

protected:
    virtual bool saveDownloadedData(const QByteArray &data);

    QNetworkReply *mReply = nullptr;
    QVector<AdBlockRule *> mRules;

private:
    QString mTitle;
    QString mFilePath;

    QUrl mUrl;
    QNetworkAccessManager *mNetworkAccessManager = nullptr;
    bool mUpdated = false;
    bool mEnabled = true;
};

class AdBlockCustomList : public AdBlockSubscription
{
    Q_OBJECT
public:
    explicit AdBlockCustomList(QObject *parent = nullptr);

    void loadSubscription(const QStringList &disabledRules) override;
    void saveSubscription() override;

    bool canEditRules() const override;
    bool canBeRemoved() const override;

    bool containsFilter(const QString &filter) const;
    bool removeFilter(const QString &filter);

    int addRule(AdBlockRule *rule) override;
    bool removeRule(int offset) override;
    const AdBlockRule *replaceRule(AdBlockRule *rule, int offset) override;
private:
    QByteArray readAllFileByteContents(const QString &filename);
};
}

#endif // ADBLOCKSUBSCRIPTION_H
