{-
    Kaya - My favourite toy language.
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU General
    Public Licence. See COPYING for licence.
-}

module Driver(compileFile) where

import Parser
import Language
-- import Typecheck
import Inference
import TAC
import CodegenCPP
import Module
import APIDocs
import Options
import LambdaLift
import Optimise
import Propagate
import Inliner
import CallGraph
import PureFun
import Lib
import Errors
import ProgramDump
import REPL

import System
import System.Directory
import Portability
import System.Random
import IO
import Debug.Trace
import List
import Control.Monad

-- Compile a file, with extra options to gcc, and main options. Returns the
-- result of the REPL, or what we should do next. If there's no REPL, as will
-- be the normal case in batch compilation, this'll just tell us to quit.

-- FIXME: This has evolved into a horrible mess of hacks. It works though,
-- so I'm reluctant to refactor it.
-- Please feel free to rewrite it neatly yourself, provided it still works!

compileFile :: InputType -> Name -> FilePath -> [String] -> Options -> Bool ->
               IO REPLRes
compileFile prtype modname fn extra opts mainfile =
    do libdirs <- getAllLibDirs opts
       pinput <- if (doprelude opts) 
		     then do
			    prelude <- 
				do foo <- Module.findFile libdirs "Prelude.ki" 
				   case foo of
				     Nothing -> return ""
				     (Just p) -> return p
			    return (parseprog "Prelude" libdirs prelude "Prelude.ki")
		     else return $ Success []
       prog <- readFile fn
       let (UN newroot) = modname
	  -- Parse properly, using the real module name, and startup code.
	  -- (This is a bit of a hack, but at least the last parse was mostly 
	  -- lazy)
       catch (do startup <- getStartup prtype libdirs
                 let pt = addToPT (parse newroot libdirs (prog++startup) fn) pinput 
                 compile newroot libdirs opts pt extra mainfile)
             (\e -> do putStrLn (show e)
                       return CompError)

outputfile Module mod = showuser mod ++ ".o"
-- TMP HACK: This should probably be a %extension "cgi" directive in the .ks
outputfile (Program "webapp") mod = showuser mod ++ ".cgi"
outputfile (Program "cgi") mod = showuser mod ++ ".cgi"
outputfile (Program _) mod = showuser mod
outputfile Shebang mod = showuser mod
outputfile SharedLib mod = showuser mod ++ ".o"
-- outputfile Webapp mod = showuser mod ++ ".cgi"
-- outputfile Webprog mod = showuser mod ++ ".cgi"

compile :: String -> [FilePath] -> Options -> 
	   (Result ParseResult) -> [String] -> Bool -> IO REPLRes
compile root libdirs opts (Failure err file line) extra mainfile 
    = do putStrLn err
         return CompError
--	 exitWith (ExitFailure 1)
compile root libdirs opts prog@(Success (PR t mod xs mdocstr)) extrain mainfile = 
    do dump (dumpraw opts) xs
       let extra = if t == Shebang then [] else extrain
       case (inferAll (UN root) empty [] [] empty [] empty [] (dumpeqns opts) xs opts) of
	    Success (ok,[],ctxt,gctxt,ectxt,tags,types) -> 
                do let ok' = if (doprelude opts)
			       then (Imported "Prelude"):ok
			       else ok
                   let t' = if mainfile && (mkso opts) then SharedLib else t
                   comp' t' root libdirs opts ctxt (nub (lambdalift ok')) extra mainfile mod mdocstr (gctxt,ectxt,tags,types)
	    Success (ok,errs,ctxt,_,_,_,_) -> 
                               do mapM_ reportError errs
				  return CompError -- exitWith (ExitFailure 1)
	    Failure err f l -> do reportError err
				  return CompError -- exitWith (ExitFailure 1)
  where	dump True raw = putStr $ concat (map ((\x -> x++"\n\n").show) raw)
	dump False raw = return ()

comp' t root libdirs opts ctxt okin extra mainfile mod mdocstr infdata = do
       -- If we're making a shared object for the repl, we need to import
       -- Reflect for dumping the output values. We also need to make sure
       -- the symbols in refl_glue are exported.
       let ok = if (mkso opts) 
                then (Imported "Reflect") : (Imported "repl_glue") : okin 
                else okin 
       let globbed = findPure (sortprog (addGlobInit ok mod))

       let optLevel = if (noopts opts) then 0 else 1
       let inls = getInlinable globbed
       let optimised = runOpts optLevel globbed

       if (dumpcg opts) 
	  then putStrLn $ dumpCG (makeCG optimised)
	  else return ()
       dumppt (dumptree opts) optimised
       dumpugly (dumpsimpl opts) optimised
       case (compileAll optimised mod) of
          Failure err f l -> do reportError err
				return CompError -- exitWith (ExitFailure 1)
	  Success comp -> do
	     let dynlinks = getdynlinks opts []
	     dlinks <- linkFiles libdirs dynlinks
	     (ofiles,linkopts) <- case t of 
		   Module -> return ([],[])
		   _ -> getObjs ok libdirs dlinks
	     let ifile = root ++ ".ki"
	     let xfile = root ++ ".xml"
	     let hfile = root ++ ".html"
	     doWriteIface t inls ifile optimised
	     doWriteXMLDocs (xmldocs opts) xfile optimised (root++".k") mdocstr
	     doWriteHTMLDocs (htmldocs opts) hfile optimised (root++".k")
--       putStrLn (show ok)
--       let name = tmpdir++root++".vcc"
--       putStrLn $ tmpdir++ " is tmp"
	     (tmpn,tmph) <- tempfile
--       putStrLn $ tmpn++ " is file"
	     aeskey <- case t of
                      Module -> return (RawCode $ "")
                      _ -> case getseed opts of
		                Nothing -> mkaeskey 0
		                (Just x) -> mkaeskey (hash x)
	     ivec <- case t of 
                     Module -> return (RawCode $ "")
                     _ -> case getseed opts of
		               Nothing -> mkivec 0
		               (Just x) -> mkivec (hash (x++"ivec"))
	     dump (dumptac opts) comp
    -- FIXME: (UN root) really ought to be mod, but I need to fix the
    -- parser to update the module name when it discovers what it is.
	     writeC (UN root) t libdirs ctxt 
			(addfnmap t optimised comp [aeskey,ivec]) tmph opts
             withpic <- case t of
                            Module -> return (picopt True)
                            _ -> return (picopt (picobj opts))
             binopts <- case t of
                            Module -> return ""
                            SharedLib -> return ""
                            _ -> return extragccbin
	     let doprofile = if (profile opts) then "-g -pg " else ""
	     let dyncmd = "g++ " ++ nocheck ++ addc t ++ " " ++ 
		       " -O2 " ++ withpic ++
                       "-fno-optimize-sibling-calls " ++ 
		       --		 "-g " ++
                       extragcc ++
                       binopts ++
		       doprofile ++
		       "-x c++ " ++
		       tmpn ++ " -x none -o " ++ 
		       outputfile t mod ++ " " ++ (unwords extra) ++ " " ++ 
		       incl libdirs ++ 
                       libflags libdirs ++
		       showofiles t ofiles ++ " " ++
                       showlist linkopts ++ " " ++
		       dolink t 
             let cmd = dostatic dyncmd (static opts) t
	     when (showgcc opts) $ putStrLn cmd
	     exit <- system cmd
             -- If we want a shared lib, make one in addition
             res <- makeSO t (libflags libdirs ++ showlist ofiles ++ showlist linkopts) (outputfile t mod) ctxt infdata
	     copyc (keepc opts) tmpn root
	     removeFile tmpn
	     if (exit /= ExitSuccess) 
		then return CompError -- exitWith exit
		else return res
  where addc Module = "-c"
        addc SharedLib = "-c"
	addc _ = ""
	dolink Module = ""
        dolink SharedLib = ""
	dolink _ = libopts++" "++libvm++" -lgc"

        doslink | linkInSOs = libopts++" "++libvm++" -lgc"
                | otherwise = "" 
        showofiles Module f = ""
        showofiles SharedLib f = ""
        showofiles _ f = showlist f
        dostatic cmd False _ = cmd ++ extragccdyn
        dostatic cmd _ Module = cmd
        dostatic cmd _ SharedLib = cmd
        dostatic cmd True _ = "libtool --quiet --mode=link " ++ cmd ++ " -all-static"
        libopts = concat $ map (" -L"++) libpath
	libvm = if (fastvm opts) then "-lkayavm-fast" else 
                    if (nortchecks opts) then "-lkayavm-opt" else "-lkayavm"
	nocheck = if (nortchecks opts || fastvm opts) then "-DNOCHECK " else ""
        doWriteIface Module inls ifile ok = writeIface inls ifile ok
	doWriteIface _ _ _ _ = return ()
	doWriteXMLDocs True dfile ok inf mdocstr = writeXMLDocs dfile ok inf mdocstr
	doWriteXMLDocs _ _ _ _ _ = return ()
	doWriteHTMLDocs True dfile ok inf = writeHTMLDocs dfile ok inf
	doWriteHTMLDocs _ _ _ _ = return ()
--	addfnmap Webapp ok comp dk = comp++((mkfnmap ok):dk)
--	addfnmap Webprog ok comp dk = comp++((mkfnmap ok):dk)
	addfnmap (Program _) ok comp dk = comp++((mkfnmap ok):(mkStartup ok):dk)
	addfnmap Shebang ok comp dk = comp++((mkfnmap ok):(mkStartup ok):dk)
	addfnmap Module ok comp dk = comp
	addfnmap SharedLib ok comp dk = comp
	dump True tac = putStr $ showtac tac
	dump False tac = return ()
	dumppt True tree = do putStr $ showtree tree
	dumppt False tree = return ()
	dumpugly True tree = do putStr $ dumpall tree
	dumpugly False tree = return ()
	copyc True n cfn = do foo <- system $ "cp " ++ n ++ " " ++ cfn ++ ".cc"
			      return ()
	copyc False _ _ = return ()
        makeSO SharedLib lopts ofile ctxt (gctxt, ectxt, tags, types) = do
            let outfile = "./" ++ showuser mod ++ ".so"
            let cmd = "g++ " ++ gccshared ++ " " ++ 
                      fpicopt ++ " " ++ extragcc ++ " " ++
                      lopts ++ " " ++ ofile ++ " -o " ++ 
                      outfile ++ doslink
	    when (showgcc opts) $ putStrLn cmd
            system cmd
            -- run the REPL
            runREPL outfile mod libdirs ctxt ectxt gctxt tags types
        makeSO _ _ _ _ _ = return Quit
	picopt False = ""
	picopt True = fpicopt ++ " "
	showlist [] = " "
	showlist (x:xs) = x ++ " " ++ showlist xs
	incl [] = ""
	incl (x:xs) = "-I"++(stripSlash x) ++ " " ++ incl xs
        libflags [] = ""
	libflags (x:xs) = " -L"++(stripSlash x)++" "++libflags xs


showIfTrue :: Bool -> String -> IO ()
showIfTrue True str = putStrLn str
showIfTrue False _ = return ()

