# We don't support COMPRESSED table when innodb_page_size is 32k or 64k.

SET GLOBAL innodb_file_per_table=1;
SET GLOBAL innodb_file_format=Barracuda;

# Test strict mode
SET SESSION innodb_strict_mode=ON;

-- error ER_ILLEGAL_HA
CREATE TABLE t1 (id int, a TEXT) ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=4;
SHOW WARNINGS;

-- error ER_ILLEGAL_HA
CREATE TABLE t1 (id int, a TEXT) ROW_FORMAT=COMPRESSED;
SHOW WARNINGS;

-- error ER_ILLEGAL_HA
CREATE TABLE t1(id int, a TEXT) KEY_BLOCK_SIZE=4;
SHOW WARNINGS;

CREATE TABLE t1 (id int, a TEXT);
SHOW WARNINGS;

-- error ER_ILLEGAL_HA_CREATE_OPTION
ALTER TABLE t1 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=4;
SHOW WARNINGS;

-- error ER_ILLEGAL_HA_CREATE_OPTION
ALTER TABLE t1 ROW_FORMAT=COMPRESSED;
SHOW WARNINGS;

-- error ER_ILLEGAL_HA_CREATE_OPTION
ALTER TABLE t1 KEY_BLOCK_SIZE=4;
SHOW WARNINGS;

DROP TABLE t1;

# Test non strict mode
SET SESSION innodb_strict_mode=OFF;

CREATE TABLE t1 (id int, a TEXT) ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=4;
DROP TABLE t1;

CREATE TABLE t1 (id int, a TEXT) ROW_FORMAT=COMPRESSED;
DROP TABLE t1;

CREATE TABLE t1 (id int, a TEXT) KEY_BLOCK_SIZE=4;
DROP TABLE t1;

CREATE TABLE t1 (id int, a TEXT);

ALTER TABLE t1 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=4;

ALTER TABLE t1 ROW_FORMAT=COMPRESSED;

ALTER TABLE t1 KEY_BLOCK_SIZE=4;

DROP TABLE t1;

SET GLOBAL innodb_file_per_table=default;
SET GLOBAL innodb_file_format=default;
