# Response - Изменение cтатус кода

Вы, вероятно, уже читали о том, что можно установить [Состояние ответа по умолчанию](../tutorial/response-status-code.md){.internal-link target=_blank}.

Но в некоторых случаях вам нужно вернуть код состояния, отличный от установленного по умолчанию.

## Пример использования

Например, представьте, что вы хотите возвращать HTTP код состояния "OK" `200` по умолчанию.

Но если данные не существовали, вы хотите создать их и вернуть HTTP код состояния "CREATED" `201`.

При этом вы всё ещё хотите иметь возможность фильтровать и преобразовывать возвращаемые данные с помощью `response_model`.

Для таких случаев вы можете использовать параметр `Response`.

## Использование параметра `Response`

Вы можете объявить параметр типа `Response` в вашей *функции обработки пути* (так же как для cookies и headers).

И затем вы можете установить `status_code` в этом *временном* объекте ответа.

{* ../../docs_src/response_change_status_code/tutorial001.py hl[1,9,12] *}

После этого вы можете вернуть любой объект, который вам нужен, как обычно (`dict`, модель базы данных и т.д.).

И если вы объявили `response_model`, он всё равно будет использоваться для фильтрации и преобразования возвращаемого объекта.

**FastAPI** будет использовать этот *временный* ответ для извлечения кода состояния (а также cookies и headers) и поместит их в финальный ответ, который содержит возвращаемое вами значение, отфильтрованное любым `response_model`.

Вы также можете объявить параметр `Response` в зависимостях и установить код состояния в них. Но помните, что последнее установленное значение будет иметь приоритет.
