# -*- coding: utf-8 -*-
#
# Graphical interface for the eSpeak speech synthesizer
#
# Copyright © 2009-2010 Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os
import sys
import gconf
import locale
import gettext
import logging
import optparse
import subprocess

# Constants

version = '0.3'
basedir = os.path.join(os.path.dirname(__file__), '..')
# It's really a .ui file, but distutils i18n wants .glade
interface_file = os.path.join(basedir, 'data/interface.glade')
icon_file = os.path.join(basedir, 'data/espeak-gui.png')

# Internationalization

gettext.install('espeak-gui', unicode=True)
locale.setlocale(locale.LC_ALL, "") # for unicode sorting with locale.strcoll

# GConf

settings = gconf.Client()

settings_prefix = '/apps/espeak-gui'
settings_selected_voice = '%s/voice/language' % settings_prefix
settings_speed = '%s/speed' % settings_prefix
settings_punctuation = '%s/punctuation' % settings_prefix
settings_gender = '%s/voice/gender' % settings_prefix
settings.add_dir('/apps/espeak-gui', gconf.CLIENT_PRELOAD_RECURSIVE)

# OptionParser

parser = optparse.OptionParser(version=version)
options, arguments = parser.parse_args()

# Start another instance of espeak-gui
def new_instance():
    subprocess.Popen([sys.argv[0]])

__all__ = [
    'version',
    'interface_file', 'icon_file',
    'settings', 'settings_selected_voice', 'settings_speed',
    'settings_punctuation', 'settings_gender',
    'options', 'arguments', 'new_instance'
]
