#ifndef _INPUT_H
#define _INPUT_H 1

#include <stddef.h>
#include <time.h>
#include <string>

#include "thread.h"

class Input;
class InputProto;

// Extremely rudimentary URL parsing.
bool parse_url(const std::string &url, std::string *protocol, std::string *user, std::string *host, std::string *port, std::string *path);

// Figure out the right type of input based on the URL, and create a new Input of the right type.
// Will return NULL if unknown.
Input *create_input(const std::string &url);
Input *create_input(const InputProto &serialized);

// Digested statistics for writing to logs etc.
struct InputStats {
	std::string url;

	// The number of bytes we have received so far, including any Metacube headers.
	//
	// Not reset across connections.
	size_t bytes_received;

	// The number of data bytes we have received so far (or more precisely,
	// number of data bytes we have sent on to the stream). This excludes Metacube
	// headers and corrupted data we've skipped.
	//
	// Not reset across connections.
	size_t data_bytes_received;

	// When the current connection was initiated. -1 if we are not currently connected.
	time_t connect_time;

	// TODO: Number of loss events might both be useful,
	// similar to for clients. Also, per-connection byte counters.
};

class Input : public Thread {
public:
	virtual ~Input();
	virtual InputProto serialize() const = 0;
	virtual std::string get_url() const = 0;
	virtual void close_socket() = 0;
	virtual void add_destination(int stream_index) = 0;

	// Note: May be called from a different thread, so must be thread-safe.
	virtual InputStats get_stats() const = 0;
};

#endif  // !defined(_INPUT_H)
