/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU Lesser General Public License, Version 2.1,
 * February 1999, which is contained in the read-me file named
 * "README_GNU_LGPL." This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2.1 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 *
 * read functions for the lcd. we handle both buttons and 
 * reading from the panel. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "lcdutils.h"
#include "lcd_private.h"

void lcd_rev_format( char *in ) {
	int  one, two, three, four;
	
	sscanf(in,"%d.%d.%d.%d", &one, &two, &three, &four);
	if (one > 255) one = 0;
	if (two > 255) two = 0;
	if (three > 255) three = 0;
	if (four > 255) four = 0;
	sprintf(in,"%03d.%03d.%03d.%03d",one,two,three,four);
} 


int lcd_netbutton(void *lcd) {
	int 	firstdigit = 0;
	int   button, i, ctr=0;
	
	lcd_set(lcd, LCD_Cursor_On);
	while( 1 ) {
		button = lcd_readbutton(lcd) & 0x00FF;
		if ( (button != BUTTON_NONE) && (button != BUTTON_NONE_B) ) {
			ctr++;
			if ( (ctr==lcd_button_debounce(lcd)) ) {
				switch (button) {
					case BUTTON_Left:
					case BUTTON_Left_B:
						i = lcd_getcursorpos(lcd);
						if (i != 0x40) {
							lcd_set(lcd, LCD_Cursor_Left);
							i = lcd_getcursor(lcd);
							if (i == '.')
								lcd_set(lcd, LCD_Cursor_Left);
						}
						break;
					
					case BUTTON_Right:
					case BUTTON_Right_B:
						i = lcd_getcursorpos(lcd);
						if (i != 0x4E) {
							lcd_set(lcd, LCD_Cursor_Right);
							i = lcd_getcursor(lcd);
							if (i == '.')
								lcd_set(lcd, LCD_Cursor_Right);
						}
						break;
					
					case BUTTON_Up:
					case BUTTON_Up_B:
						i = lcd_getcursorpos(lcd);
						firstdigit = 0;
						firstdigit = ( i == 0x40 ) || ( i == 0x44 ) || ( i == 0x48 ) || ( i == 0x4C );
						i = lcd_getcursor(lcd);
						if (i == '9')
							i = '0';
						else if ((i == '2') && (firstdigit))
							i = '0';
						else	
							i++;
						lcd_setcursor(lcd, i);
						break;
					
					case BUTTON_Down:
					case BUTTON_Down_B:
						i = lcd_getcursorpos(lcd);
						firstdigit = 0;
						firstdigit = ( i == 0x40 ) || ( i == 0x44 ) || ( i == 0x48 ) || ( i == 0x4C );
						i = lcd_getcursor(lcd);
						if ((i == '0') && (!firstdigit))
							i = '9';
						else if ((i == '0') && (firstdigit))
							i = '2'; 
						else
							i--;
						lcd_setcursor(lcd, i);
						break;
					
					case BUTTON_Next:
					case BUTTON_Next_B:
						break;
					
					case BUTTON_Enter:
					case BUTTON_Enter_B:
						lcd_getdisplay(lcd, NULL, NULL, &i);
						return i;
						break;
				}
				lcd_netcorrect(lcd);
			}
			if (ctr==lcd_button_sense(lcd)) {
				ctr=0;
			}
		}
		else {
			ctr=0;
		}
	}
}

static void mangle_num(char *line) {
	char *first = line + 1, *second = line + 2;
	
	if ( *line == '2' ) {
		if ( *first == '9' )
			*first = '5';
		else if ( *first > '5' )
			*first = '0';
		else if (*first == '5') {
			if (*second == '9') 
				*second = '5';
			else if (*second > '5') 
				*second = '0';
		}  
	}
}

void lcd_netcorrect(void *lcd) {
	char last_address;
	char *line1, last_line1[LCD_CHARS_PER_LINE];
	char *line2, last_line2[LCD_CHARS_PER_LINE];
	
	last_address = lcd_getcursorpos(lcd);
	lcd_getdisplay(lcd, &line1, &line2, NULL);
	strcpy(last_line1, line1); 
	strcpy(last_line2, line2); 
	
	
	mangle_num(last_line2);
	mangle_num(last_line2 + 4);
	mangle_num(last_line2 + 8);
	mangle_num(last_line2 + 12);
	lcd_write(lcd, last_line1, last_line2);
	lcd_setcursorpos(lcd, last_address);
	lcd_set(lcd, LCD_Cursor_On);
}
