package charactermanaj.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * カスタムレイヤー順の定義リストからレイヤーに対する順序を索引できるようにする。
 */
public class CustomLayerOrderMapper implements LayerOrderMapper {

	private Map<Layer, Float> layerOrderMap;

	public CustomLayerOrderMapper() {
		this(null);
	}

	public CustomLayerOrderMapper(Collection<CustomLayerOrder> orders) {
		initMapping(orders);
	}

	public final void initMapping(Collection<CustomLayerOrder> orders) {
		this.layerOrderMap = createLayerOrderMap(orders);
	}

	private static Map<Layer, Float> createLayerOrderMap(Collection<CustomLayerOrder> orders) {
		Map<Layer, Float> layerOrderMap = new HashMap<Layer, Float>();
		if (orders != null) {
			for (CustomLayerOrder layerOrder : orders) {
				Layer layer = layerOrder.getLayer();
				float order = layerOrder.getLayerOrder();
				layerOrderMap.put(layer, order);
			}
		}
		return layerOrderMap;
	}

	@Override
	public float getLayerOrder(Layer layer) {
		Float order = layerOrderMap.get(layer);
		if (order == null) {
			order = (float) layer.getOrder();
		}
		return order;
	}
}
