/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** SCALUPD **
c ** Update the scalars using conservative or convective differencing of fluxes
c *************************************************************************

      subroutine scalupd(s,sn,sedgex,sedgey,uadv,vadv,
     $                   diff,force,areax,areay,vol,DIMS,
     $                   dx,dt,is_conserv,numscal)

      implicit none

      integer DIMS
      integer numscal
      REAL_T       s(lo_1-3:hi_1+3,lo_2-3:hi_2+3,numscal)
      REAL_T      sn(lo_1-3:hi_1+3,lo_2-3:hi_2+3,numscal)
      REAL_T  sedgex(lo_1  :hi_1+1,lo_2  :hi_2  ,numscal)
      REAL_T  sedgey(lo_1  :hi_1  ,lo_2  :hi_2+1,numscal)
      REAL_T    uadv(lo_1:hi_1+1,lo_2:hi_2  )
      REAL_T    vadv(lo_1:hi_1  ,lo_2:hi_2+1)
      REAL_T    diff(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numscal)
      REAL_T   force(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numscal)
      REAL_T   areax(lo_1  :hi_1+1,lo_2  :hi_2  )
      REAL_T   areay(lo_1  :hi_1  ,lo_2  :hi_2+1)
      REAL_T     vol(lo_1-1:hi_1+1,lo_2-1:hi_2+1)
      REAL_T dx(2)
      REAL_T dt
      integer is_conserv(numscal)

c     Local variables
      REAL_T  divsu
      REAL_T  uconv
      REAL_T  vconv
      integer i,j,n

      do n = 1, numscal

      if (is_conserv(n) .eq. 1) then

        do j = lo_2,hi_2
        do i = lo_1,hi_1

          divsu = ( sedgex(i+1,j,n)*uadv(i+1,j)*areax(i+1,j) - 
     $              sedgex(i  ,j,n)*uadv(i  ,j)*areax(i  ,j)
     $            + sedgey(i,j+1,n)*vadv(i,j+1)*areay(i,j+1) - 
     $              sedgey(i,j  ,n)*vadv(i,j  )*areay(i,j  ) ) / vol(i,j)

          sn(i,j,n) = s(i,j,n) - dt*divsu + half*dt*diff(i,j,n)+dt*force(i,j,n)

        enddo
        enddo
 
      else 

        do j = lo_2,hi_2
        do i = lo_1,hi_1

          uconv = half * (uadv(i+1,j) + uadv(i,j))
          vconv = half * (vadv(i,j+1) + vadv(i,j))

          divsu = uconv * (sedgex(i+1,j,n) - sedgex(i,j,n)) / dx(1)  +
     $            vconv * (sedgey(i,j+1,n) - sedgey(i,j,n)) / dx(2) 

          sn(i,j,n) = s(i,j,n) - dt*divsu + half*dt*diff(i,j,n) + dt*force(i,j,n)

        enddo
        enddo

      endif

      enddo

      return
      end
