/*
    This file is part of audtty, copyright 2008-2010 Chris Taylor.

    audtty is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    audtty is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with audtty; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#define __USE_GNU // to get strcasestr
#include <glib.h>
#include <glib/gstdio.h>
#include "main.h"
#include <stdlib.h>
#include <stdio.h>
#include "playlist.h"
#include <time.h>
#include <string.h>
#include "curses_printf.h"
#include "kbd_constants.h"

extern struct timespec interval;
extern playlist list;
extern windows wins;

void playlist_create( void )
{
        gint len = 0;
        gint i = 0;
        FILE *file;
	gchar buffer[1024];
	buffer[0] = '\0';
	while (true) {
		gint c;

		while((c = getch()) != ERR) {
			switch (c) {
				case ESCAPE:
                                        return;
				case ENTER:
                                        file=fopen(buffer,"w");
                                        for(i=0;i<list.length;i++)
                                        {
                                            fputs(g_filename_from_uri(list.song[i].file,NULL,NULL),file);
                                            fputs("\n",file);
                                        }
                                        fclose(file);
                                        return;
				case KEY_BACKSPACE:
					if (len == 0) break;
					buffer[--len] = '\0';
					break;
				default:
					if (len == 1025) break;
					if (c < 32) break;
					buffer[len] = c;
					buffer[++len] = '\0';
					break;
			}
		}

		gint x, y;
		mvwaddnstrf(wins.status, 0, 0, "Save as: %s", -1, buffer);
		getyx(wins.status, y, x);
		wclrtoeol(wins.status);
		mvwchgat(wins.status, 0, 0, -1, A_BOLD, 1, NULL);
		wnoutrefresh(wins.status);


		doupdate();
        }

        return;
}