/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.dsl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.cobertura.check.CoverageThreshold;
import net.sourceforge.cobertura.instrument.CoberturaFile;
import net.sourceforge.cobertura.util.FileFinder;
import org.apache.oro.text.regex.Pattern;

public class Arguments {
    private String baseDirectory;
    private File dataFile;
    private File destinationDirectory;
    private File commandsFile;
    private FileFinder sources;
    private Collection ignoreRegexes;
    private Collection<Pattern> ignoreBranchesRegexes;
    private Collection<Pattern> classPatternIncludeClassesRegexes;
    private Collection<Pattern> classPatternExcludeClassesRegexes;
    private boolean calculateMethodComplexity;
    private boolean failOnError;
    private boolean ignoreTrivial;
    private boolean threadsafeRigorous;
    private String encoding;
    private Set<CoverageThreshold> minimumCoverageThresholds;
    private double classLineThreshold;
    private double classBranchThreshold;
    private double packageLineThreshold;
    private double packageBranchThreshold;
    private double totalLineThreshold;
    private double totalBranchThreshold;
    private Set<CoberturaFile> filesToInstrument;
    private Set<File> filesToMerge;
    private Set<String> ignoreMethodAnnotations;
    private Set<String> ignoreClassAnnotations;

    Arguments(String baseDirectory, File dataFile, File destinationDirectory, File commandsFile, Collection ignoreRegexes, Collection<Pattern> ignoreBranchesRegexes, Collection<Pattern> classPatternIncludeClassesRegexes, Collection<Pattern> classPatternExcludeClassesRegexes, boolean calculateMethodComplexity, boolean failOnError, boolean ignoreTrivial, boolean threadsafeRigorous, String encoding, Set<CoverageThreshold> minimumCoverageThresholds, double classLineThreshold, double classBranchThreshold, double packageLineThreshold, double packageBranchThreshold, double totalLineThreshold, double totalBranchThreshold, Set<CoberturaFile> filesToInstrument, Set<File> filesToMerge, Set<String> ignoreMethodAnnotations, Set<String> ignoreClassAnnotations, FileFinder sources) {
        this.baseDirectory = baseDirectory;
        this.dataFile = dataFile;
        this.destinationDirectory = destinationDirectory;
        this.commandsFile = commandsFile;
        this.ignoreRegexes = ignoreRegexes;
        this.sources = sources;
        this.ignoreBranchesRegexes = Collections.unmodifiableCollection(ignoreBranchesRegexes);
        this.classPatternIncludeClassesRegexes = Collections.unmodifiableCollection(classPatternIncludeClassesRegexes);
        this.classPatternExcludeClassesRegexes = Collections.unmodifiableCollection(classPatternExcludeClassesRegexes);
        this.calculateMethodComplexity = calculateMethodComplexity;
        this.failOnError = failOnError;
        this.ignoreTrivial = ignoreTrivial;
        this.threadsafeRigorous = threadsafeRigorous;
        this.encoding = encoding;
        this.minimumCoverageThresholds = Collections.unmodifiableSet(minimumCoverageThresholds);
        this.classLineThreshold = classLineThreshold;
        this.classBranchThreshold = classBranchThreshold;
        this.packageLineThreshold = packageLineThreshold;
        this.packageBranchThreshold = packageBranchThreshold;
        this.totalLineThreshold = totalLineThreshold;
        this.totalBranchThreshold = totalBranchThreshold;
        this.filesToInstrument = Collections.unmodifiableSet(filesToInstrument);
        this.filesToMerge = Collections.unmodifiableSet(filesToMerge);
        this.ignoreMethodAnnotations = Collections.unmodifiableSet(ignoreMethodAnnotations);
        this.ignoreClassAnnotations = Collections.unmodifiableSet(ignoreClassAnnotations);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public File getCommandsFile() {
        return this.commandsFile;
    }

    public Collection getIgnoreRegexes() {
        return this.ignoreRegexes;
    }

    public Collection<Pattern> getIgnoreBranchesRegexes() {
        return this.ignoreBranchesRegexes;
    }

    public Collection<Pattern> getClassPatternIncludeClassesRegexes() {
        return this.classPatternIncludeClassesRegexes;
    }

    public Collection<Pattern> getClassPatternExcludeClassesRegexes() {
        return this.classPatternExcludeClassesRegexes;
    }

    public boolean isCalculateMethodComplexity() {
        return this.calculateMethodComplexity;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isIgnoreTrivial() {
        return this.ignoreTrivial;
    }

    public boolean isThreadsafeRigorous() {
        return this.threadsafeRigorous;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Set<CoverageThreshold> getMinimumCoverageThresholds() {
        return this.minimumCoverageThresholds;
    }

    public double getClassLineThreshold() {
        return this.classLineThreshold;
    }

    public double getClassBranchThreshold() {
        return this.classBranchThreshold;
    }

    public double getPackageLineThreshold() {
        return this.packageLineThreshold;
    }

    public double getPackageBranchThreshold() {
        return this.packageBranchThreshold;
    }

    public double getTotalLineThreshold() {
        return this.totalLineThreshold;
    }

    public double getTotalBranchThreshold() {
        return this.totalBranchThreshold;
    }

    public Set<CoberturaFile> getFilesToInstrument() {
        return this.filesToInstrument;
    }

    public Set<File> getFilesToMerge() {
        return this.filesToMerge;
    }

    public Set<String> getIgnoreMethodAnnotations() {
        return this.ignoreMethodAnnotations;
    }

    public FileFinder getSources() {
        return this.sources;
    }

    public Set<String> getIgnoreClassAnnotations() {
        return this.ignoreClassAnnotations;
    }
}

