#!/bin/bash
#
# generate python files based on the designer ui files. pyuic4 and pyrcc4
# should be on the path.
#

if [ ! -d "designer" ]
then
    echo "Please run this from the project root"
    exit
fi

mkdir -p aqt/forms

init=aqt/forms/__init__.py
temp=aqt/forms/scratch
rm -f $init $temp
echo "# This file auto-generated by build_ui.sh. Don't edit." > $init
echo "__all__ = [" >> $init

echo "Generating forms.."
for i in designer/*.ui
do
    base=$(basename $i .ui)
    py="aqt/forms/${base}.py"
    echo "	\"$base\"," >> $init
    echo "import $base" >> $temp
    if [ $i -nt $py ]; then
        echo " * "$py
        pyuic4 $i -o $py
        # munge the output to use gettext
        perl -pi.bak -e 's/QtGui.QApplication.translate\(".*?", /_(/; s/, None, QtGui.*/))/' $py
        rm $py.bak
    fi
done
echo "]" >> $init
cat $temp >> $init
rm $temp

echo "Building resources.."
pyrcc4 designer/icons.qrc -o aqt/forms/icons_rc.py
