# 1 Are "anarcho"-capitalists really anarchists?

In a word, no. While "anarcho"-capitalists obviously try to associate
themselves with the anarchist tradition by using the word "anarcho" or by
calling themselves "anarchists", their ideas are distinctly at odds with those
associated with anarchism. As a result, any claims that their ideas are
anarchist or that they are part of the anarchist tradition or movement are
false.

"Anarcho"-capitalists claim to be anarchists because they say that they oppose
government. As such, as noted in the [last section](append13int.md), they
use a dictionary definition of anarchism. However, this fails to appreciate
that anarchism is a **political theory**, not a dictionary definition. As
dictionaries are rarely politically sophisticated things, this means that they
fail to recognise that anarchism is more than just opposition to government,
it is also marked a opposition to capitalism (i.e. exploitation and private
property). Thus, opposition to government is a necessary but not sufficient
condition for being an anarchist -- you also need to be opposed to
exploitation and capitalist private property. As "anarcho"-capitalists do not
consider interest, rent and profits (i.e. capitalism) to be exploitative nor
oppose capitalist property rights, they are not anarchists.

Moreover, "anarcho"-capitalism is inherently self-refuting. This can be seen
from leading "anarcho"-capitalist Murray Rothbard. he thundered against the
evil of the state, arguing that it _"arrogates to itself a monopoly of force,
of ultimate decision-making power, over a given area territorial area."_ In
and of itself, this definition is unremarkable. That a few people (an elite of
rulers) claim the right to rule others must be part of any sensible definition
of the state or government. However, the problems begin for Rothbard when he
notes that _"[o]bviously, in a free society, Smith has the ultimate decision-
making power over his own just property, Jones over his, etc."_ [**The Ethics
of Liberty**, p. 170 and p. 173] The logical contradiction in this position
should be obvious, but not to Rothbard. It shows the power of ideology, the
ability of means words (the expression _"private property"_) to turn the bad
(_"ultimate decision-making power over a given area"_) into the good
(_"ultimate decision-making power over a given area"_).

Now, this contradiction can be solved in only **one** way -- the owners of the
_"given area"_ are also its users. In other words, a system of possession (or
"occupancy and use") as favoured by anarchists. However, Rothbard is a
capitalist and supports private property. In other words, wage labour and
landlords. This means that he supports a divergence between ownership and use
and this means that this _"ultimate decision-making power"_ extends to those
who **use,** but do not own, such property (i.e. tenants and workers). The
statist nature of private property is clearly indicated by Rothbard's words --
the property owner in an "anarcho"-capitalist society possesses the _"ultimate
decision-making power"_ over a given area, which is also what the state has
currently. Rothbard has, ironically, proved by his own definition that
"anarcho"-capitalism is not anarchist.

Rothbard does try to solve this obvious contradiction, but utterly fails. He
simply ignores the crux of the matter, that capitalism is based on hierarchy
and, therefore, cannot be anarchist. He does this by arguing that the
hierarchy associated with capitalism is fine as long as the private property
that produced it was acquired in a "just" manner. In so doing he yet again
draws attention to the identical authority structures and social relationships
of the state and property. As he puts it:

> _"**If** the State may be said too properly **own** its territory, then it
is proper for it to make rules for everyone who presumes to live in that area.
It can legitimately seize or control private property because there **is** no
private property in its area, because it really owns the entire land surface.
**So long** as the State permits its subjects to leave its territory, then, it
can be said to act as does any other owner who sets down rules for people
living on his property."_ [**Op. Cit.**, p. 170]

Obviously Rothbard argues that the state does not "justly" own its territory
-- but given that the current distribution of property is just as much the
result of violence and coercion as the state, his argument is seriously
flawed. It amounts, as we note in [section 4](append134.md), to little more
than an _**"immaculate conception of property"**_ unrelated to reality. Even
assuming that private property was produced by the means Rothbard assumes, it
does not justify the hierarchy associated with it as the current and future
generations of humanity have, effectively, been excommunicated from liberty by
previous ones. If, as Rothbard argues, property is a natural right and the
basis of liberty then why should the many be excluded from their birthright by
a minority? In other words, Rothbard denies that liberty should be universal.
He chooses property over liberty while anarchists choose liberty over
property.

Even worse, the possibility that private property can result in **worse**
violations of individual freedom (at least of workers) than the state of its
citizens was implicitly acknowledged by Rothbard. He uses as a hypothetical
example a country whose King is threatened by a rising "libertarian" movement.
The King responses by _"employ[ing] a cunning stratagem,"_ namely he
_"proclaims his government to be dissolved, but just before doing so he
arbitrarily parcels out the entire land area of his kingdom to the 'ownership'
of himself and his relatives."_ Rather than taxes, his subjects now pay rent
and he can _"regulate to regulate the lives of all the people who presume to
live on"_ his property as he sees fit. Rothbard then asks:

> _"Now what should be the reply of the libertarian rebels to this pert
challenge? If they are consistent utilitarians, they must bow to this
subterfuge, and resign themselves to living under a regime no less despotic
than the one they had been battling for so long. Perhaps, indeed, **more**
despotic, for now the king and his relatives can claim for themselves the
libertarians' very principle of the absolute right of private property, an
absoluteness which they might not have dared to claim before."_ [**Op. Cit.**,
pp. 54-5]

So not only does the property owner have the same monopoly of power over a
given area as the state, it is **more** despotic as it is based on the
_"absolute right of private property"_! And remember, Rothbard is arguing **in
favour** of "anarcho"-capitalismAnd remember, Rothbard is arguing **in
favour** of "anarcho"-capitalism (_"if you have unbridled capitalism, you will
have all kinds of authority: you will have **extreme** authority."_ [Chomksy,
**Understanding Power**, p. 200]). So in practice, private property is a major
source of oppression and authoritarianism within society -- there is little or
no freedom within capitalist production (as Bakunin noted, _"the worker sells
his person and his liberty for a given time"_). So, in stark contrast to
anarchists, "anarcho"-capitalists have no problem with factory fascism (i.e.
wage labour), a position which seems highly illogical for a theory calling
itself libertarian. If it were truly libertarian, it would oppose all forms of
domination, not just statism. This position flows from the
"anarcho"-capitalist definition of freedom as the absence of coercion and will
be discussed in [section 2](append132.md) in more detail.

Of course, Rothbard has yet another means to escape the obvious, namely that
the market will limit the abuses of the property owners. If workers do not
like their ruler then they can seek another. However, this reply completely
ignores the reality of economic and social power. Thus the "consent" argument
fails because it ignores the social circumstances of capitalism which limit
the choice of the many. Anarchists have long argued that, as a class, workers
have little choice but to "consent" to capitalist hierarchy. The alternative
is either dire poverty or starvation.

"Anarcho"-capitalists dismiss such claims by denying that there is such a
thing as economic power. Rather, it is simply freedom of contract. Anarchists
consider such claims as a joke. To show why, we need only quote (yet again)
Rothbard on the abolition of slavery and serfdom in the 19th century. He
argued, correctly, that the _"**bodies** of the oppressed were freed, but the
property which they had worked and eminently deserved to own, remained in the
hands of their former oppressors. With economic power thus remaining in their
hands, the former lords soon found themselves virtual masters once more of
what were now free tenants or farm labourers. The serfs and slaves had tasted
freedom, but had been cruelly derived of its fruits."_ [**Op. Cit.**, p. 74]

To say the least, anarchists fail to see the logic in this position. Contrast
this with the standard "anarcho"-capitalist claim that if market forces
("voluntary exchanges") result in the creation of _"free tenants or farm
labourers"_ then they are free. Yet labourers dispossessed by market forces
are in exactly the same social and economic situation as the ex-serfs and ex-
slaves. If the latter do not have the fruits of freedom, neither do the
former. Rothbard sees the obvious _"economic power"_ in the latter case, but
denies it in the former. It is only Rothbard's ideology that stops him from
drawing the obvious conclusion -- identical economic conditions produce
identical social relationships and so capitalism is marked by _"economic
power"_ and _"virtual masters."_ The only solution is for
"anarcho"-capitalists to simply say the ex-serfs and ex-slaves were actually
free to choose and, consequently, Rothbard was wrong. It might be inhuman, but
at least it would be consistent!

Rothbard's perspective is alien to anarchism. For example, as individualist
anarchist William Bailie noted, under capitalism there is a class system
marked by _"a dependent industrial class of wage-workers"_ and _"a privileged
class of wealth-monopolisers, each becoming more and more distinct from the
other as capitalism advances."_ This has turned property into _"a social
power, an economic force destructive of rights, a fertile source of injustice,
a means of enslaving the dispossessed."_ He concludes: _"Under this system
equal liberty cannot obtain."_ Bailie notes that the modern _"industrial world
under capitalistic conditions"_ have _"arisen under the **regime** of status"_
(and so _"law-made privileges"_) however, it seems unlikely that he would have
concluded that such a class system would be fine if it had developed naturally
or the current state was abolished while leaving the class structure intact
(as we note in [section G.4](secG4.md), Tucker recognised that even the
_"freest competition"_ was powerless against the _"enormous concentration of
wealth"_ associated with modern capitalism). [**The Individualist
Anarchists**, p. 121]

Therefore anarchists recognise that "free exchange" or "consent" in unequal
circumstances will reduce freedom as well as increasing inequality between
individuals and classes. In other words, as we discuss in [section
3](append133.md), inequality will produce social relationships which are
based on hierarchy and domination, **not** freedom. As Noam Chomsky put it:

> _"Anarcho-capitalism, in my opinion, is a doctrinal system which, if ever
implemented, would lead to forms of tyranny and oppression that have few
counterparts in human history. There isn't the slightest possibility that its
(in my view, horrendous) ideas would be implemented, because they would
quickly destroy any society that made this colossal error. The idea of 'free
contract' between the potentate and his starving subject is a sick joke,
perhaps worth some moments in an academic seminar exploring the consequences
of (in my view, absurd) ideas, but nowhere else."_ [**Noam Chomsky on
Anarchism**, interview with Tom Lane, December 23, 1996]

Clearly, then, by its own arguments "anarcho"-capitalism is not anarchist.
This should come as no surprise to anarchists. Anarchism, as a political
theory, was born when Proudhon wrote **What is Property?** specifically to
refute the notion that workers are free when capitalist property forces them
to seek employment by landlords and capitalists. He was well aware that in
such circumstances property _"violates equality by the rights of exclusion and
increase, and freedom by despotism . . . [and has] perfect identity with
robbery."_ He, unsurprisingly, talks of the _"proprietor, to whom [the worker]
has sold and surrendered his liberty."_ For Proudhon, anarchy was _"the
absence of a master, of a sovereign"_ while _"proprietor"_ was _"synonymous"_
with _"sovereign"_ for he _"imposes his will as law, and suffers neither
contradiction nor control."_ This meant that _"property engenders despotism,"_
as _"each proprietor is sovereign lord within the sphere of his property."_
[**What is Property**, p. 251, p. 130, p. 264 and pp. 266-7] It must also be
stressed that Proudhon's classic work is a lengthy critique of the kind of
apologetics for private property Rothbard espouses to salvage his ideology
from its obvious contradictions.

Ironically, Rothbard repeats the same analysis as Proudhon but draws the
**opposite** conclusions and expects to be considered an anarchist! Moreover,
it seems equally ironic that "anarcho"-capitalism calls itself "anarchist"
while basing itself on the arguments that anarchism was created in opposition
to. As shown, "anarcho"-capitalism makes as much sense as "anarcho-statism" --
an oxymoron, a contradiction in terms. The idea that "anarcho"-capitalism
warrants the name "anarchist" is simply false. Only someone ignorant of
anarchism could maintain such a thing. While you expect anarchist theory to
show this to be the case, the wonderful thing is that "anarcho"-capitalism
itself does the same.

Little wonder Bob Black argues that _"[t]o demonise state authoritarianism
while ignoring identical albeit contract-consecrated subservient arrangements
in the large-scale corporations which control the world economy is fetishism
at its worst."_ [**Libertarian as Conservative**] The similarities between
capitalism and statism are clear -- and so why "anarcho"-capitalism cannot be
anarchist. To reject the authority (the _"ultimate decision-making power"_) of
the state and embrace that of the property owner indicates not only a highly
illogical stance but one at odds with the basic principles of anarchism. This
whole-hearted support for wage labour and capitalist property rights indicates
that "anarcho"-capitalists are not anarchists because they do not reject all
forms of **archy.** They obviously support the hierarchy between boss and
worker (wage labour) and landlord and tenant. Anarchism, by definition, is
against all forms of archy, including the hierarchy generated by capitalist
property. To ignore the obvious archy associated with capitalist property is
highly illogical.

In addition, we must note that such inequalities in power and wealth will need
"defending" from those subject to them ("anarcho"-capitalists recognise the
need for private police and courts to defend property from theft -- and,
anarchists add, to defend the theft and despotism associated with property!).
Due to its support of private property (and thus authority),
"anarcho"-capitalism ends up retaining a state in its "anarchy"; namely a
**private** state whose existence its proponents attempt to deny simply by
refusing to call it a state, like an ostrich hiding its head in the sand (see
[section 6](append136.md) for more on this and why "anarcho"-capitalism is
better described as "private state" capitalism). As Albert Meltzer put it:

> _"Common-sense shows that any capitalist society might dispense with a
'State' . . . but it could not dispense with organised government, or a
privatised form of it, if there were people amassing money and others working
to amass it for them. The philosophy of 'anarcho-capitalism' dreamed up by the
'libertarian' New Right, has nothing to do with Anarchism as known by the
Anarchist movement proper. It is a lie . . . Patently unbridled capitalism . .
. needs some force at its disposal to maintain class privileges, either form
the State itself or from private armies. What they believe in is in fact a
limited State -- that us, one in which the State has one function, to protect
the ruling class, does not interfere with exploitation, and comes as cheap as
possible for the ruling class. The idea also serves another purpose . . . a
moral justification for bourgeois consciences in avoiding taxes without
feeling guilty about it."_ [**Anarchism: Arguments For and Against**, p. 50]

For anarchists, this need of capitalism for some kind of state is
unsurprising. For _"Anarchy without socialism seems equally as impossible to
us [as socialism without anarchy], for in such a case it could not be other
than the domination of the strongest, and would therefore set in motion right
away the organisation and consolidation of this domination; that is to the
constitution of government."_ [Errico Malatesta, **Life and Ideas**, p. 148]
Because of this, the "anarcho"-capitalist rejection of anarchist ideas on
capitalist property economics and the need for equality, they cannot be
considered anarchists or part of the anarchist tradition.

Thus anarchism is far more than the common dictionary definition of "no
government" -- it also entails being against all forms of **archy**, including
those generated by capitalist property. This is clear from the roots of the
word "anarchy." As we noted in [section A.1](secA1.md), the word anarchy
means "no rulers" or "contrary to authority." As Rothbard himself
acknowledges, the property owner is the ruler of their property and,
therefore, those who use it. For this reason "anarcho"-capitalism cannot be
considered as a form of anarchism -- a real anarchist must logically oppose
the authority of the property owner along with that of the state. As
"anarcho"-capitalism does not explicitly (or implicitly, for that matter) call
for economic arrangements that will end wage labour and usury it cannot be
considered anarchist or part of the anarchist tradition.

Political theories should be identified by their actual features and history
rather than labels. Once we recognise that, we soon find out that
"anarcho"-capitalism is an oxymoron. Anarchists and "anarcho"-capitalists are
not part of the same movement or tradition. Their ideas and aims are in direct
opposition to those of all kinds of anarchists.

While anarchists have always opposed capitalism, "anarcho"-capitalists have
embraced it. And due to this embrace their "anarchy" will be marked by
extensive differences in wealth and power, differences that will show
themselves up in relationships based upon subordination and hierarchy (such as
wage labour), **not** freedom (little wonder that Proudhon argued that
_"property is despotism"_ \-- it creates authoritarian and hierarchical
relationships between people in a similar way to statism).

Their support for "free market" capitalism ignores the impact of wealth and
power on the nature and outcome of individual decisions within the market (see
sections [2](append132.md) and [3](append133.md) for further discussion).
For example, as we indicate in sections [J.5.10](secJ5.md#secj510),
[J.5.11](secJ5.md#secj511) and [J.5.12](secJ5.md#secj512), wage labour is
less efficient than self-management in production but due to the structure and
dynamics of the capitalist market, "market forces" will actively discourage
self-management due to its empowering nature for workers. In other words, a
developed capitalist market will promote hierarchy and unfreedom in production
in spite of its effects on individual workers and their wants (see also
[section 10.2](append1310.md#secf102)). Thus "free market" capitalism tends
to re-enforce inequalities of wealth and power, **not** eliminate them.

Furthermore, any such system of (economic and social) power will require
extensive force to maintain it and the "anarcho"-capitalist system of
competing "defence firms" will simply be a new state, enforcing capitalist
power, property rights and law.

Overall, the lack of concern for meaningful freedom within production and the
effects of vast differences in power and wealth within society as a whole
makes "anarcho"-capitalism little better than "anarchism for the rich." Emma
Goldman recognised this when she argued that _"'Rugged individualism' has
meant all the 'individualism' for the masters . . . in whose name political
tyranny and social oppression are defended and held up as virtues while every
aspiration and attempt of man to gain freedom . . . is denounced as . . . evil
in the name of that same individualism."_ [**Red Emma Speaks**, p. 112] And,
as such, is no anarchism at all.

So, unlike anarchists, "anarcho"-capitalists do not seek the _"abolition of
the proletariat"_ (to use Proudhon's expression) via changing capitalist
property rights and institutions. Thus the "anarcho"-capitalist and the
anarchist have different starting positions and opposite ends in mind and so
they cannot be considered part of the same (anarchist) tradition. As we
discuss further in later sections, the "anarcho"-capitalist claims to being
anarchists are bogus simply because they reject so much of the anarchist
tradition as to make what they do accept non-anarchist in theory and practice.
Little wonder Peter Marshall said that _"few anarchists would accept the
'anarcho-capitalists' into the anarchist camp since they do not share a
concern for economic equality and social justice."_ [**Demanding the
Impossible**, p. 565]

## 1.1 Why is the failure to renounce hierarchy the Achilles Heel of right-
wing libertarianism

Any capitalist system will produce vast differences in economic (and social)
wealth and power. As we argue in [section 3.1](append133.md#secf31), such
differences will reflect themselves in the market and any "free" contracts
agreed there will create hierarchical relationships. Thus capitalism is marked
by hierarchy (see [section B.1.2](secB1.md#secb12)) and, unsurprisingly,
right-libertarians and "anarcho"-capitalists fail to oppose such "free market"
generated hierarchy.

Both groups approve of it in the capitalist workplace or rented accommodation
and the right-Libertarians also approve of it in a 'minimal' state to protect
private property ("anarcho"-capitalists, in contrast, approve of the use of
private defence firms to protect property). But the failure of these two
movements to renounce hierarchy is their weakest point. For anti-
authoritarianism has sunk deep roots into the modern psyche, as a legacy of
the sixties.

Many people who do not even know what anarchism is have been profoundly
affected by the personal liberation and counterculture movements of the past
thirty years, epitomised by the popular bumper sticker, _"Question
Authority."_ As a result, society now tolerates much more choice than ever
before in matters of religion, sexuality, art, music, clothing, and other
components of lifestyle. We need only recall the conservatism that reigned in
such areas during the fifties to see that the idea of liberty has made
tremendous advances in just a few decades.

Although this liberatory impulse has so far been confined almost entirely to
the personal and cultural realms, it may yet be capable of spilling over and
affecting economic and political institutions, provided it continues to grow.
The Right is well aware of this, as seen in its ongoing campaigns for "family
values," school prayer, suppression of women's rights, fundamentalist
Christianity, sexual abstinence before marriage, and other attempts to revive
the Ozzie-and-Harriet mindset of the Good Old Days. This is where the efforts
of "cultural anarchists" -- artists, musicians, poets, and others -- are
important in keeping alive the ideal of personal freedom and resistance to
authority as a necessary foundation for economic and political restructuring.

Indeed, the libertarian right (as a whole) support restrictions on freedom
**as long as its not the state that is doing it**! Their support for
capitalism means that they have no problem with bosses dictating what workers
do during working hours (nor outside working hours, if the job requires
employees to take drug tests or not be gay in order to keep it). If a private
landlord or company decrees a mandatory rule or mode of living, workers/tenets
must "love it or leave it!" Of course, that the same argument also applies to
state laws is one hotly denied by right-Libertarians -- a definite case of not
seeing the wood for the trees (see [section 2.3](append132.md#secf23)).

Of course, the "anarcho"-capitalist will argue, workers and tenants can find a
more liberal boss or landlord. This, however, ignores two key facts. Firstly,
being able to move to a more liberal state hardly makes state laws less
offensive (as they themselves will be the first to point out). Secondly,
looking for a new job or home is not that easy. Just a moving to a new state
can involve drastic upheavals, so change changing jobs and homes. Moreover,
the job market is usually a buyers market (it has to be in capitalism,
otherwise profits are squeezed -- see sections [C.7](secC7.md) and
[10.2](append1310.md#secf102)) and this means that workers are not usually
in a position (unless they organise) to demand increased liberties at work.

It seems somewhat ironic, to say the least, that right-libertarians place
rights of property over the rights of self-ownership, even though (according
to their ideology) self-ownership is the foundational right from which
property rights are derived. Thus in right-libertarianism the rights of
property owners to discriminate and govern the property-less are more
important than the freedom from discrimination (i.e. to be yourself) or the
freedom to govern oneself at all times.

So, when it boils down to it, right-libertarians are not really bothered about
restrictions on liberty and, indeed, they will defend private restrictions on
liberty with all their might. This may seem a strange position for self-
proclaimed "libertarians" to take, but it flows naturally from their
definition of freedom (see [section 2](append132.md) for a full discussion
of this). but by not attacking hierarchy beyond certain forms of statism, the
'libertarian' right fundamentally undermines its claim to be libertarian.
Freedom cannot be compartmentalised, but is holistic. The denial of liberty
in, say, the workplace, quickly results in its being denied elsewhere in
society (due to the impact of the inequalities it would produce) , just as the
degrading effects of wage labour and the hierarchies with which is it bound up
are felt by the worker outside work.

Neither the Libertarian Party nor so-called "anarcho"-capitalism is
**genuinely** anti-authoritarian, as those who are truly dedicated to liberty
must be.

## 1.2 How libertarian is right-Libertarian theory?

The short answer is, not very. Liberty not only implies but also requires
independent, critical thought (indeed, anarchists would argue that critical
thought requires free development and evolution and that it is precisely
**this** which capitalist hierarchy crushes). For anarchists a libertarian
theory, if it is to be worthy of the name, must be based upon critical thought
and reflect the key aspect that characterises life - change and the ability to
evolve. To hold up dogma and base "theory" upon assumptions (as opposed to
facts) is the opposite of a libertarian frame of mind. A libertarian theory
must be based upon reality and recognise the need for change and the existence
of change. Unfortunately, right-Libertarianism is marked more by ideology than
critical analysis.

Right-Libertarianism is characterised by a strong tendency of creating
theories based upon assumptions and deductions from these axioms (for a
discussion on the pre-scientific nature of this methodology and of its
dangers, see the [next section](append131.md#secf13)). Robert Nozick, for
example, in **Anarchy, State, and Utopia** makes no attempt to provide a
justification of the property rights his whole theory is based upon. His main
assumption is that _"[i]ndividuals have rights, and there are certain things
no person or group may do to them (without violating their rights)."_
[**Anarchy, State and Utopia**, p. ix] While this does have its intuitive
appeal, it is not much to base a political ideology upon. After all, what
rights people consider as valid can be pretty subjective and have constantly
evolved during history. To say that "individuals have rights" is to open up
the question "what rights?" Indeed, as we argue in greater length in [section
2](append132.md), such a rights based system as Nozick desires can and does
lead to situations developing in which people "consent" to be exploited and
oppressed and that, intuitively, many people consider supporting the
"violation" of these "certain rights" (by creating other ones) simply because
of their evil consequences.

In other words, starting from the assumption "people have [certain] rights"
Nozick constructs a theory which, when faced with the reality of unfreedom and
domination it would create for the many, justifies this unfreedom as an
expression of liberty. In other words, regardless of the outcome, the initial
assumptions are what matter. Nozick's intuitive rights system can lead to some
very non-intuitive outcomes.

And does Nozick prove the theory of property rights he assumes? He states that
_"we shall not formulate [it] here."_ [**Op. Cit.**, p. 150] Moreover, it is
not formulated anywhere else in his book. And if it is not formulated, what is
there to defend? Surely this means that his Libertarianism is without
foundations? As Jonathan Wolff notes, Nozick's _"Libertarian property rights
remain substantially undefended."_ [**Robert Nozick: Property, Justice and the
Minimal State**, p. 117] Given that the right to acquire property is critical
to his whole theory you would think it important enough to go into in some
detail (or at least document). After all, unless he provides us with a firm
basis for property rights then his entitlement theory is nonsense as no one
has the right to (private) property.

It could be argued that Nozick **does** present enough information to allow us
to piece together a possible argument in favour of property rights based on
his modification of the _"Lockean Proviso"_ (although he does not point us to
these arguments). However, assuming this is the case, such a defence actually
fails (see [ section B.3.4](secB3.md#secb34) for more on this). If
individuals **do** have rights, these rights do not include property rights in
the form Nozick assumes (but does not prove). Nozick appears initially
convincing because what he assumes with regards to property is a normal
feature of the society we are in (we would be forgiven when we note here that
feeble arguments pass for convincing when they are on the same side as the
prevailing sentiment).

Similarly, both Murray Rothbard and Ayn Rand (who is infamous for repeating
_"A is A"_ ad infinitum) do the same - base their ideologies on assumptions
(see [section 11](append1311.md) for more on this).

Therefore, we see that most of the leading right-Libertarian ideologues base
themselves on assumptions about what "Man" is or the rights they should have
(usually in the form that people have (certain) rights because they are
people). From these theorems and assumptions they build their respective
ideologies, using logic to deduce the conclusions that their assumptions
imply. Such a methodology is unscientific and, indeed, a relic of religious
(pre-scientific) society (see [next section](append131.md#secf13)) but, more
importantly, can have negative effects on maximising liberty. This is because
this "methodology" has distinct problems. Murray Bookchin argues:

> _"Conventional reason rests on identity, not change; its fundamental
principle is that **A equals A,** the famous 'principle of identity,' which
means that any given phenomenon can be only itself and cannot be other than
what we immediately perceive it to be at a given moment in time. It does not
address the problem of change. A human being is an infant at one time, a child
at another, an adolescent at still another, and finally a youth and an adult.
When we analyse an infant by means of conventional reason, we are not
exploring what it is **becoming** in the process of developing into a child."_
[_"A Philosophical Naturalism"_, **Society and Nature** No.2, p. 64]

In other words, right-Libertarian theory is based upon ignoring the
fundamental aspect of life - namely **change** and **evolution.** Perhaps it
will be argued that identity also accounts for change by including
potentiality -- which means, that we have the strange situation that A can
**potentially** be A! If A is not actually A, but only has the potential to be
A, then A is not A. Thus to include change is to acknowledge that A does not
equal A -- that individuals and humanity evolves and so what constitutes A
also changes. To maintain identity and then to deny it seems strange.

That change is far from the "A is A" mentality can be seen from Murray
Rothbard who goes so far as to state that _"one of the notable attributes of
natural law"_ is _"its applicability to all men [sic!], regardless of time or
place. Thus ethical law takes its place alongside physical or 'scientific'
natural laws."_ [**The Ethics of Liberty**, p. 42] Apparently the "nature of
man" is the only living thing in nature that does not evolve or change! Of
course, it could be argued that by "natural law" Rothbard is only referring to
his method of deducing his (and, we stress, they are just his -- not natural)
"ethical laws" -- but his methodology starts by assuming certain things about
"man." Whether these assumptions seem far or not is besides the point, by
using the term "natural law" Rothbard is arguing that any actions that violate
**his** ethical laws are somehow "against nature" (but if they were against
nature, they could not occur -- see [section 11](append137.md) for more on
this). Deductions from assumptions is a Procrustean bed for humanity (as
Rothbard's ideology shows).

So, as can be seen, many leading right-Libertarians place great store by the
axiom "A is A" or that "man" has certain rights simply because "he" is a
"man". And as Bookchin points out, such conventional reason _"doubtless plays
an indispensable role in mathematical thinking and mathematical sciences . . .
and in the nuts-and-bolts of dealing with everyday life"_ and so is essential
to _"understand or design mechanical entities."_ [**Ibid.**, p.67] But the
question arises, is such reason useful when considering people and other forms
of life?

Mechanical entities are but one (small) aspect of human life. Unfortunately
for right-Libertarians (and fortunately for the rest of humanity), human
beings are **not** mechanical entities but instead are living, breathing,
feeling, hoping, dreaming, **changing** living organisms. They are not
mechanical entities and any theory that uses reason based on such (non-living)
entities will flounder when faced with living ones. In other words, right-
Libertarian theory treats people as the capitalist system tries to -- namely
as commodities, as things. Instead of human beings, whose ideas, ideals and
ethics change, develop and grow, capitalism and capitalist ideologues try to
reduce human life to the level of corn or iron (by emphasising the unchanging
"nature" of man and their starting assumptions/rights).

This can be seen from their support for wage labour, the reduction of human
activity to a commodity on the market. While paying lip service to liberty and
life, right-libertarianism justifies the commodification of labour and life,
which within a system of capitalist property rights can result in the treating
of people as means to an end as opposed to an end in themselves (see sections
[2](append132.md) and [3.1](append133.md#secf31)).

And as Bookchin points out, _"in an age of sharply conflicting values and
emotionally charges ideals, such a way of reasoning is often repellent.
Dogmatism, authoritarianism, and fear seem all-pervasive."_ [**Ibid.**, p. 68]
Right-Libertarianism provides more than enough evidence for Bookchin's summary
with its support for authoritarian social relationships, hierarchy and even
slavery (see [section 2](append132.md)).

This mechanical viewpoint is also reflected in their lack of appreciation that
social institutions and relationships evolve over time and, sometimes,
fundamentally change. This can best be seen from property. Right-libertarians
fail to see that over time (in the words of Proudhon) property _"changed its
nature."_ Originally, _"the word **property** was synonymous with . . .
**individual possession**"_ but it became more _"complex"_ and turned into
**private property** \-- _"the right to use it by his neighbour's labour."_
The changing of use-rights to (capitalist) property rights created relations
of domination and exploitation between people absent before. For the right-
Libertarian, both the tools of the self-employed artisan and the capital of a
transnational corporation are both forms of "property" and (so) basically
identical. In practice, of course, the social relations they create and the
impact they have on society are totally different. Thus the mechanical mind-
set of right-Libertarianism fails to understand how institutions, like
property, evolve and come to replace whatever freedom enhancing features they
had with oppression (indeed, von Mises argued that _"[t]here may possibly be a
difference of opinion about whether a particular institution is socially
beneficial or harmful. But once it has been judged [by whom, we ask]
beneficial, one can no longer contend that, for some inexplicable reason, it
must be condemned as immoral"_ [**Liberalism**, p. 34] So much for evolution
and change!).

Anarchism, in contrast, is based upon the importance of critical thought
informed by an awareness that life is in a constant process of change. This
means that our ideas on human society must be informed by the facts, not by
what we wish was true. For Bookchin, an evaluation of conventional wisdom (as
expressed in _"the law of identity"_) is essential and its conclusions have
_"enormous importance for how we behave as ethical beings, the nature of
nature, and our place in the natural world. Moreover. . . these issues
directly affect the kind of society, sensibility, and lifeways we wish to
foster."_ [Bookchin, **Op. Cit.**, p. 69-70]

Bookchin is correct. While anarchists oppose hierarchy in the name of liberty,
right-libertarians support authority and hierarchy, all of which deny freedom
and restrict individual development. This is unsurprising because the right-
libertarian ideology rejects change and critical thought based upon the
scientific method and so is fundamentally **anti-life** in its assumptions and
**anti-human** in its method. Far from being a libertarian set of ideas,
right-Libertarianism is a mechanical set of dogmas that deny the fundamental
nature of life (namely change) and of individuality (namely critical thought
and freedom). Moreover, in practice their system of (capitalist) rights would
soon result in extensive restrictions on liberty and authoritarian social
relationships (see sections [2](append132.md) and [3](append133.md)) -- a
strange result of a theory proclaiming itself "libertarian" but one consistent
with its methodology.

From a wider viewpoint, such a rejection of liberty by right-libertarians is
unsurprising. They do, after all, support capitalism. Capitalism produces an
inverted set of ethics, one in which capital (dead labour) is more important
that people (living labour). After all, workers are usually easier to replace
than investments in capital and the person who owns capital commands the
person who "only" owns his life and productive abilities. And as Oscar Wilde
once noted, crimes against property _"are the crimes that the English law,
valuing what a man has more than what a man is, punishes with the harshest and
most horrible severity."_ [**The Soul of Man Under Socialism**]

This mentality is reflected in right-libertarianism when it claims that
stealing food is a crime while starving to death (due to the action of market
forces/power and property rights) is no infringement of your rights (see
[section 4.2](append134.md#secf42) for a similar argument with regards to
water). It can also be seen when right-libertarian's claim that the taxation
_"of earnings from labour"_ (e.g. of one dollar from a millionaire) is _"**on
a par with** forced labour"_ [Nozick, **Op. Cit.**, p. 169] while working in a
sweatshop for 14 hours a day (enriching said millionaire) does not affect your
liberty as you "consent" to it due to market forces (although, of course, many
rich people have earned their money **without** labouring themselves -- their
earnings derive from the wage labour of others so would taxing those, non-
labour, earnings be "forced labour"?) Interestingly, the Individualist
Anarchist Ben Tucker argued that an income tax was _"a recognition of the fact
that industrial freedom and equality of opportunity no longer exist here [in
the USA in the 1890s] even in the imperfect state in which they once did
exist"_ [quoted by James Martin, **Men Against the State**, p. 263] which
suggests a somewhat different viewpoint on this matter than Nozick or
Rothbard.

That capitalism produces an inverted set of ethics can be seen when the Ford
produced the Pinto. The Pinto had a flaw in it which meant that if it was hit
in a certain way in a crash the fuel tank exploded. The Ford company decided
it was more "economically viable" to produce that car and pay damages to those
who were injured or the relatives of those who died than pay to change the
invested capital. The needs for the owners of capital to make a profit came
before the needs of the living. Similarly, bosses often hire people to perform
unsafe work in dangerous conditions and fire them if they protest. Right-
libertarian ideology is the philosophical equivalent. Its dogma is "capital"
and it comes before life (i.e. "labour").

As Bakunin once put it, _"you will always find the idealists in the very act
of practical materialism, while you will see the materialists pursuing and
realising the most grandly ideal aspirations and thoughts."_ [**God and the
State**, p. 49] Hence we see right "libertarians" supporting sweat shops and
opposing taxation -- for, in the end, money (and the power that goes with it)
counts far more in that ideology than ideals such as liberty, individual
dignity, empowering, creative and productive work and so forth for all. The
central flaw of right-libertarianism is that it does not recognise that the
workings of the capitalist market can easily ensure that the majority end up
becoming a resource for others in ways far worse than that associated with
taxation. The legal rights of self-ownership supported by right-libertarians
does not mean that people have the ability to avoid what is in effect
enslavement to another (see sections [2](append132.md) and
[3](append133.md)).

Right-Libertarian theory is not based upon a libertarian methodology or
perspective and so it is hardly surprising it results in support for
authoritarian social relationships and, indeed, slavery (see [section
2.6](append132.md#secf26)).

## 1.3 Is right-Libertarian theory scientific in nature?

Usually, no. The scientific approach is **inductive,** much of the right-
libertarian approach is **deductive.** The first draws generalisations from
the data, the second applies preconceived generalisations to the data. A
completely deductive approach is pre-scientific, however, which is why many
right-Libertarians cannot legitimately claim to use a scientific method.
Deduction does occur in science, but the generalisations are primarily based
on other data, not _a priori_ assumptions, and are checked against data to see
if they are accurate. Anarchists tend to fall into the inductive camp, as
Kropotkin put it:

> _"Precisely this natural-scientific method applied to economic facts,
enables us to prove that the so-called 'laws' of middle-class sociology,
including also their political economy, are not laws at all, but simply
guesses, or mere assertions which have never been verified at all."_
[**Kropotkin's Revolutionary Pamphlets**, p. 153]

The idea that natural-scientific methods can be applied to economic and social
life is one that many right-libertarians reject. Instead they favour the
deductive (pre-scientific) approach (this we must note is not limited purely
to Austrian economists, many more mainstream capitalist economists also
embrace deduction over induction).

The tendency for right-Libertarianism to fall into dogmatism (or _a priori_
theorems, as they call it) and its implications can best be seen from the work
of Ludwig von Mises and other economists from the right-Libertarian "Austrian
school." Of course, not all right-libertarians necessarily subscribe to this
approach (Murray Rothbard for one did) but its use by so many leading lights
of both schools of thought is significant and worthy of comment. And as we are
concentrating on **methodology** it is not essential to discuss the starting
assumptions. The assumptions (such as, to use Rothbard's words, the Austrian's
_"fundamental axiom that individual human beings act"_) may be correct,
incorrect or incomplete -- but the method of using them advocated by von Mises
ensures that such considerations are irrelevant.

Von Mises (a leading member of the Austrian school of economics) begins by
noting that social and economic theory _"is not derived from experience; it is
prior to experience..."_ Which is back to front. It is obvious that experience
of capitalism is necessary in order to develop a viable theory about how it
works. Without the experience, any theory is just a flight of fantasy. The
actual specific theory we develop is therefore derived from experience,
informed by it and will have to get checked against reality to see if it is
viable. This is the scientific method - any theory must be checked against the
facts. However, von Mises goes on to argue at length that _"no kind of
experience can ever force us to discard or modify **a priori** theorems; they
are logically prior to it and cannot be either proved by corroborative
experience or disproved by experience to the contrary . . ."_

And if this does not do justice to a full exposition of the phantasmagoria of
von Mises' _a priorism_, the reader may take some joy (or horror) from the
following statement:

> _"If a contradiction appears between a theory and experience, **we must
always assume** that a condition pre-supposed by the theory was not present,
or else there is some error in our observation. The disagreement between the
theory and the facts of experience frequently forces us to think through the
problems of the theory again. **But so long as a rethinking of the theory
uncovers no errors in our thinking, we are not entitled to doubt its truth**"_
[emphasis added -- the quotes presented here are cited in **Ideology and
Method in Economics** by Homa Katouzian, pp. 39-40]

In other words, if reality is in conflict with your ideas, do not adjust your
views because reality must be at fault! The scientific method would be to
revise the theory in light of the facts. It is not scientific to reject the
facts in light of the theory! This anti-scientific perspective is at the heart
of his economics as experience _"can never . . . prove or disprove any
particular theorem"_:

> _ "What assigns economics to its peculiar and unique position in the orbit
of pure knowledge and of the practical utilisation of knowledge is the fact
that its particular theorems are not open to any verification or falsification
on the grounds of experience . . .. . . The ultimate yardstick of an economic
theorem's correctness or incorrectness is solely reason unaided by
experience."_ [**Human Action**, p. 858]

Von Mises rejects the scientific approach as do all Austrian Economists.
Murray Rothbard states approvingly that _"Mises indeed held not only that
economic theory does not need to be 'tested' by historical fact but also that
it **cannot** be so tested."_ [_"Praxeology: The Methodology of Austrian
Economics"_ in **The Foundation of Modern Austrian Economics**, p. 32]
Similarly, von Hayek wrote that economic theories can _"never be verified or
falsified by reference to facts. All that we can and must verify is the
presence of our assumptions in the particular case."_ [**Individualism and
Economic Order**, p. 73]

This may seen somewhat strange to non-Austrians. How can we ignore reality
when deciding whether a theory is a good one or not? If we cannot evaluate our
ideas, how can we consider them anything bar dogma? The Austrian's maintain
that we cannot use historical evidence because every historical situation is
unique. Thus we cannot use _"complex heterogeneous historical facts as if they
were repeatable homogeneous facts"_ like those in a scientist's experiment
[Rothbard, **Op. Cit.**, p. 33]. While such a position **does** have an
element of truth about it, the extreme _a priorism_ that is drawn from this
element is radically false (just as extreme empiricism is also false, but for
different reasons).

Those who hold such a position ensure that their ideas cannot be evaluated
beyond logical analysis. As Rothbard makes clear, _"since praxeology begins
with a true axiom, A, all that can be deduced from this axiom must also be
true. For if A implies be, and A is true, then B must also be true."_ [**Op.
Cit.**, pp. 19-20] But such an approach makes the search for truth a game
without rules. The Austrian economists (and other right-libertarians) who use
this method are free to theorise anything they want, without such irritating
constrictions as facts, statistics, data, history or experimental
confirmation. Their only guide is logic. But this is no different from what
religions do when they assert the logical existence of God. Theories
ungrounded in facts and data are easily spun into any belief a person wants.
Starting assumptions and trains of logic may contain inaccuracies so small as
to be undetectable, yet will yield entirely false conclusions.

In addition, trains of logic may miss things which are only brought to light
by actual experiences (after all, the human mind is not all knowing or all
seeing). To ignore actual experience is to loose that input when evaluating a
theory. Hence our comments on the irrelevance of the assumptions used -- the
methodology is such that incomplete or incorrect assumptions or steps cannot
be identified in light of experience. This is because one way of discovering
if a given chain of logic requires checking is to test its conclusions against
available evidence (although von Mises did argue that the _"ultimate
yardstick"_ was _"solely reason unaided by experience"_). If we **do** take
experience into account and rethink a given theory in the light of
contradictory evidence, the problem remains that a given logical chain may be
correct, but incomplete or concentrate on or stress inappropriate factors. In
other words, our logical deductions may be correct but our starting place or
steps wrong and as the facts are to be rejected in the light of the deductive
method, we cannot revise our ideas.

Indeed, this approach could result in discarding (certain forms of) human
behaviour as irrelevant (which the Austrian system claims using empirical
evidence does). For there are too many variables that can have an influence
upon individual acts to yield conclusive results explaining human behaviour.
Indeed, the deductive approach may ignore as irrelevant certain human
motivations which have a decisive impact on an outcome. There could be a
strong tendency to project "right-libertarian person" onto the rest of society
and history, for example, and draw inappropriate insights into the way human
society works or has worked. This can be seen, for example, in attempts to
claim pre-capitalist societies as examples of "anarcho"-capitalism in action.

Moreover, deductive reasoning cannot indicate the relative significance of
assumptions or theoretical factors. That requires empirical study. It could be
that a factor considered important in the theory actually turns out to have
little effect in practice and so the derived axioms are so weak as to be
seriously misleading.

In such a purely ideal realm, observation and experience are distrusted (when
not ignored) and instead theory is the lodestone. Given the bias of most
theorists in this tradition, it is unsurprising that this style of economics
can always be trusted to produce results proving free markets to be the finest
principle of social organisation. And, as an added bonus, reality can be
ignored as it is **never** "pure" enough according to the assumptions required
by the theory. It could be argued, because of this, that many right-
libertarians insulate their theories from criticism by refusing to test them
or acknowledge the results of such testing (indeed, it could also be argued
that much of right-libertarianism is more a religion than a political theory
as it is set-up in such a way that it is either true or false, with this being
determined not by evaluating facts but by whether you accept the assumptions
and logical chains presented with them).

Strangely enough, while dismissing the "testability" of theories many right-
Libertarians (including Murray Rothbard) **do** investigate historical
situations and claim them as examples of how well their ideas work in
practice. But why does historical fact suddenly become useful when it can be
used to bolster the right-Libertarian argument? Any such example is just as
"complex" as any other and the good results indicated may not be accountable
to the assumptions and steps of the theory but to other factors totally
ignored by it. If economic (or other) theory is untestable then **no**
conclusions can be drawn from history, including claims for the superiority of
laissez-faire capitalism. You cannot have it both ways -- although we doubt
that right-libertarians will stop using history as evidence that their ideas
work.

Perhaps the Austrian desire to investigate history is not so strange after
all. Clashes with reality make a-priori deductive systems implode as the
falsifications run back up the deductive changes to shatter the structure
built upon the original axioms. Thus the desire to find **some** example which
proves their ideology must be tremendous. However, the deductive a-priori
methodology makes them unwilling to admit to being mistaken -- hence their
attempts to downplay examples which refute their dogmas. Thus we have the
desire for historical examples while at the same time they have extensive
ideological justifications that ensure reality only enters their world-view
when it agrees with them. In practice, the latter wins as real-life refuses to
be boxed into their dogmas and deductions.

Of course it is sometimes argued that it is **complex** data that is the
problem. Let use assume that this is the case. It is argued that when dealing
with complex information it is impossible to use aggregate data without first
having more simple assumptions (i.e. that "humans act"). Due to the complexity
of the situation, it is argued, it is impossible to aggregate data because
this hides the individual activities that creates it. Thus "complex" data
cannot be used to invalidate assumptions or theories. Hence, according to
Austrians, the axioms derived from the "simple fact" that "humans act" are the
only basis for thinking about the economy.

Such a position is false in two ways.

Firstly, the aggregation of data **does** allow us to understand complex
systems. If we look at a chair, we cannot find out whether it is comfortable,
its colour, whether it is soft or hard by looking at the atoms that make it
up. To suggest that you can is to imply the existence of green, soft,
comfortable atoms. Similarly with gases. They are composed to countless
individual atoms but scientists do not study them by looking at those atoms
and their actions. Within limits, this is also valid for human action. For
example, it would be crazy to maintain from historical data that interest
rates will be a certain percentage a week but it is valid to maintain that
interest rates are known to be related to certain variables in certain ways.
Or that certain experiences will tend to result in certain forms of
psychological damage. General tendencies and "rules of thumb" can be evolved
from such study and these can be used to **guide** current practice and
theory. By aggregating data you can produce valid information, rules of thumb,
theories and evidence which would be lost if you concentrated on "simple data"
(such as "humans act"). Therefore, empirical study produces facts which vary
across time and place, and yet underlying and important patterns can be
generated (patterns which can be evaluated against **new** data and improved
upon).

Secondly, the simple actions themselves influence and are influenced in turn
by overall (complex) facts. People act in different ways in different
circumstances (something we can agree with Austrians about, although we refuse
to take it to their extreme position of rejecting empirical evidence as such).
To use simple acts to understand complex systems means to miss the fact that
these acts are not independent of their circumstances. For example, to claim
that the capitalist market is "just" the resultant of bilateral exchanges
ignores the fact that the market activity shapes the nature and form of these
bilateral exchanges. The "simple" data is dependent on the "complex" system --
and so the complex system **cannot** be understood by looking at the simple
actions in isolation. To do so would be to draw incomplete and misleading
conclusions (and it is due to these interrelations that we argue that
aggregate data should be used critically). This is particularly important when
looking at capitalism, where the "simple" acts of exchange in the labour
market are dependent upon and shaped by circumstances outside these acts.

So to claim that (complex) data cannot be used to evaluate a theory is false.
Data can be useful when seeing whether a theory is confirmed by reality. This
is the nature of the scientific method -- you compare the results expected by
your theory to the facts and if they do not match you check your facts **and**
check your theory. This may involve revising the assumptions, methodology and
theories you use if the evidence is such as to bring them into question. For
example, if you claim that capitalism is based on freedom but that the net
result of capitalism is to produce relations of domination between people then
it would be valid to revise, for example, your definition of freedom rather
than deny that domination restricts freedom (see [section 2](append132.md)
on this). But if actual experience is to be distrusted when evaluating theory,
we effectively place ideology above people -- after all, how the ideology
affects people in **practice** is irrelevant as experiences cannot be used to
evaluate the (logically sound but actually deeply flawed) theory.

Moreover, there is a slight arrogance in the "Austrian" dismissal of empirical
evidence. If, as they argue, the economy is just too complex to allow us to
generalise from experience then how can one person comprehend it sufficiently
to create an economic ideology as the Austrian's suggest? Surely no one mind
(or series of minds) can produce a model which accurately reflects such a
complex system? To suggest that one can deduce a theory for an exceedingly
complex social system from the theoretical work based on an analysis technique
which deliberately ignores that reality as being unreliable seems to require a
deliberate suspension of one's reasoning faculties. Of course, it may be
argued that such a task is possible, given a small enough subset of economic
activity. However, such a process is sure to lead its practitioners astray as
the subset is not independent of the whole and, consequently, can be
influenced in ways the ideologist does not (indeed, cannot) take into account.
Simply put, even the greatest mind cannot comprehend the complexities of real
life and so empirical evidence needs to inform any theory seeking to describe
and explain it. To reject it is simply to retreat into dogmatism and ideology,
which is precisely what right-wing libertarians generally do.

Ultimately, this dismissal of empirical evidence seems little more than self-
serving. It's utility to the ideologist is obvious. It allows them to
speculate to their hearts content, building models of the economy with no
bearing to reality. Their models and the conclusions it generates need never
be bothered with reality -- nor the effects of their dogma. Which shows its
utility to the powerful. It allows them to spout comments like "the free
market benefits all" while the rich get richer and allows them to brush aside
any one who points out such troublesome facts.

That this position is self-serving can be seen from the fact that most right
libertarians are very selective about applying von Mises' argument. As a rule
of thumb, it is only applied when the empirical evidence goes against
capitalism. In such circumstances the fact that the current system is not a
free market will also be mentioned. However, if the evidence seems to bolster
the case for propertarianism then empirical evidence becomes all the rage.
Needless to say, the fact that we do not have a free market will be
conveniently forgotten. Depending on the needs of the moment, fundamental
facts are dropped and retrieved to bolster the ideology.

As we indicated above (in [section 1.2](append131.md#secf12)) and will
discuss in more depth later (in [section 11](append1311.md)) most of the
leading right-Libertarian theorists base themselves on such deductive
methodologies, starting from assumptions and "logically" drawing conclusions
from them. The religious undertones of such methodology can best be seen from
the roots of right-Libertarian "Natural law" theory.

Carole Pateman, in her analysis of Liberal contract theory, indicates the
religious nature of the "Natural Law" argument so loved by the theorists of
the "Radical Right." She notes that for Locke (the main source of the
Libertarian Right's Natural Law cult) _"natural law"_ was equivalent of
_"God's Law"_ and that _"God's law exists externally to and independently of
individuals."_ [**The Problem of Political Obligation**, p. 154] No role for
critical thought there, only obedience. Most modern day "Natural Law"
supporters forget to mention this religious undercurrent and instead talk of
about "Nature" (or "the market") as the deity that creates Law, not God, in
order to appear "rational." So much for science.

Such a basis in dogma and religion can hardly be a firm foundation for liberty
and indeed "Natural Law" is marked by a deep authoritarianism:

> _"Locke's traditional view of natural law provided individual's with an
external standard which they could recognise, but which they did not
voluntarily choose to order their political life."_ [Pateman, **Op. Cit.**, p.
79]

In [section 11](append1311.md) we discuss the authoritarian nature of
"Natural Law" and will not do so here. However, here we must point out the
political conclusions Locke draws from his ideas. In Pateman's words, Locke
believed that _"obedience lasts only as long as protection. His individuals
are able to take action themselves to remedy their political lot. . . but this
does not mean, as is often assumed, that Locke's theory gives direct support
to present-day arguments for a right of civil disobedience. . . His theory
allows for two alternatives only: either people go peacefully about their
daily affairs under the protection of a liberal, constitutional government, or
they are in revolt against a government which has ceased to be 'liberal' and
has become arbitrary and tyrannical, so forfeiting its right to obedience."_
[**Op. Cit.**, p. 77]

Locke's "rebellion" exists purely to reform a **new** 'liberal' government,
not to change the existing socio-economic structure which the 'liberal'
government exists to protect. His theory, therefore, indicates the results of
a priorism, namely a denial of any form of social dissent which may change the
"natural law" as defined by Locke. This perspective can be found in Rothbard
who lambasted the individualist anarchists for arguing that juries should
judge the law as well as the facts. For Rothbard, the law would be drawn up by
jurists and lawyers, not ordinary people (see [section
1.4](append131.md#secf14) for details). The idea that those subject to laws
should have a say in forming them is rejected in favour of elite rule. As von
Mises put it:

> _ "The flowering of human society depends on two factors: the intellectual
power of outstanding men to conceive sound social and economic theories, and
the ability of these or other men to make these ideologies palatable to the
majority."_ [**Human Action**, p. 864]

Yet such a task would require massive propaganda work and would only,
ultimately, succeed by removing the majority from any say in the running of
society. Once that is done then we have to believe that the ruling elite will
be altruistic in the extreme and not abuse their position to create laws and
processes which defended what **they** thought was "legitimate" property,
property rights and what constitutes "aggression." Which, ironically,
contradicts the key capitalist notion that people are driven by self-gain. The
obvious conclusion from such argument is that any right-libertarian regime
would have to exclude change. If people can change the regime they are under
they may change it in ways that right libertarian's do not support. The
provision for ending amendments to the regime or the law would effectively ban
most opposition groups or parties as, by definition, they could do nothing
once in office (for minimal state "libertarians") or in the market for
"defence" agencies (for "anarcho"-capitalists). How this differs from a
dictatorship is hard to say -- after all, most dictatorships have
parliamentary bodies which have no power but which can talk a lot. Perhaps the
knowledge that it is **private** police enforcing **private** power will make
those subject to the regime maximise their utility by keeping quiet and not
protesting. Given this, von Mises' praise for fascism in the 1920s may be less
contradictory than it first appears (see [section 6.5](append136.md#secf65))
as it successfully "deterred democracy" by crushing the labour, socialist and
anarchist movements across the world.

So, von Mises, von Hayek and most right-libertarians reject the scientific
method in favour of ideological correctness -- if the facts contradict your
theory then they can be dismissed as too "complex" or "unique". Facts,
however, should inform theory and any theory's methodology should take this
into account. To dismiss facts out of hand is to promote dogma. This is not to
suggest that a theory should be modified very time new data comes along --
that would be crazy as unique situations **do** exist, data can be wrong and
so forth -- but it does suggest that if your theory **continually** comes into
conflict with reality, its time to rethink the theory and not assume that
facts cannot invalidate it. A true libertarian would approach a contradiction
between reality and theory by evaluating the facts available and changing the
theory is this is required, not by ignoring reality or dismissing it as
"complex".

Thus, much of right-Libertarian theory is neither libertarian nor scientific.
Much of right-libertarian thought is highly axiomatic, being logically deduced
from such starting axioms as _"self-ownership"_ or _"no one should initiate
force against another"_. Hence the importance of our discussion of von Mises
as this indicates the dangers of this approach, namely the tendency to
ignore/dismiss the consequences of these logical chains and, indeed, to
justify them in terms of these axioms rather than from the facts. In addition,
the methodology used is such as that it would be fair to argue that right-
libertarians get to critique reality but reality can never be used to critique
right-libertarianism -- for any empirical data presented as evidence as be
dismissed as "too complex" or "unique" and so irrelevant (unless it can be
used to support their claims, of course).

Hence W. Duncan Reekie's argument (quoting leading Austrian economist Israel
Kirzner) that _"empirical work 'has the function of establishing the
**applicability** of particular theorems, and thus **illustrating** their
operation' . . . Confirmation of theory is not possible because there is no
constants in human action, nor is it necessary because theorems themselves
describe relationships logically developed from hypothesised conditions.
Failure of a logically derived axiom to fit the facts does not render it
invalid, rather it 'might merely indicate inapplicability' to the
circumstances of the case.'"_ [**Markets, Entrepreneurs and Liberty**, p. 31]

So, if facts confirm your theory, your theory is right. If facts do not
confirm your theory, it is still right but just not applicable in this case!
Which has the handy side effect of ensuring that facts can **only** be used to
support the ideology, **never** to refute it (which is, according to this
perspective, impossible anyway). As Karl Popper argued, a _"theory which is
not refutable by any conceivable event is non-scientific."_ [**Conjectures and
Refutations**, p. 36] In other words (as we noted above), if reality
contradicts your theory, ignore reality!

Kropotkin hoped _"that those who believe in [current economic doctrines] will
themselves become convinced of their error as soon as they come to see the
necessity of verifying their quantitative deductions by quantitative
investigation."_ [**Op. Cit.**, p. 178] However, the Austrian approach builds
so many barriers to this that it is doubtful that this will occur. Indeed,
right-libertarianism, with its focus on exchange rather than its consequences,
seems to be based upon justifying domination in terms of their deductions than
analysing what freedom actually means in terms of human existence (see
[section 2](append132.md) for a fuller discussion).

The real question is why are such theories taken seriously and arouse such
interest. Why are they not simply dismissed out of hand, given their
methodology and the authoritarian conclusions they produce? The answer is, in
part, that feeble arguments can easily pass for convincing when they are on
the same side as the prevailing sentiment and social system. And, of course,
there is the utility of such theories for ruling elites - _"[a]n ideological
defence of privileges, exploitation, and private power will be welcomed,
regardless of its merits."_ [Noam Chomsky, **The Chomsky Reader**, p. 188]

##  1.4 Is "anarcho"-capitalism a new form of individualist anarchism?

Some "anarcho"-capitalists shy away from the term, preferring such expressions
as "market anarchist" or "individualist anarchist." This suggests that there
is some link between their ideology and that of Tucker. However, the founder
of "anarcho"-capitalism, Murray Rothbard, refused that label for, while
_"strongly tempted,"_ he could not do so because _"Spooner and Tucker have in
a sense pre-empted that name for their doctrine and that from that doctrine I
have certain differences."_ Somewhat incredibly Rothbard argued that on the
whole politically _"these differences are minor,"_ economically _"the
differences are substantial, and this means that my view of the consequences
of putting our more of less common system into practice is very far from
theirs."_ [_"The Spooner-Tucker Doctrine: An Economist's View"_, **Journal of
Libertarian Studies**, vol. 20, no. 1, p. 7]

What an understatement! Individualist anarchists advocated an economic system
in which there would have been very little inequality of wealth and so of
power (and the accumulation of capital would have been minimal without profit,
interest and rent). Removing this social and economic basis would result in
**substantially** different political regimes. This can be seen from the fate
of Viking Iceland, where a substantially communal and anarchistic system was
destroyed from within by increasing inequality and the rise of tenant farming
(see [section 9](append139.md) for details). In other words, politics is not
isolated from economics. As David Wieck put it, Rothbard _"writes of society
as though some part of it (government) can be extracted and replaced by
another arrangement while other things go on before, and he constructs a
system of police and judicial power without any consideration of the influence
of historical and economic context."_ [_"Anarchist Justice,"_ in **Nomos
XIX**, Pennock and Chapman, eds., p. 227]

Unsurprisingly, the political differences he highlights **are** significant,
namely _"the role of law and the jury system"_ and _"the land question."_ The
former difference relates to the fact that the individualist anarchists
_"allow[ed] each individual free-market court, and more specifically, each
free-market jury, totally free rein over judicial decision."_ This horrified
Rothbard. The reason is obvious, as it allows real people to judge the law as
well as the facts, modifying the former as society changes and evolves. For
Rothbard, the idea that ordinary people should have a say in the law is
dismissed. Rather, _"it would not be a very difficult task for Libertarian
lawyers and jurists to arrive at a rational and objective code of libertarian
legal principles and procedures."_ [**Op. Cit.**, p. 7-8] Of course, the fact
that _"lawyers"_ and _"jurists"_ may have a radically different idea of what
is just than those subject to their laws is not raised by Rothbard, never mind
answered. While Rothbard notes that juries may defend the people against the
state, the notion that they may defend the people against the authority and
power of the rich is not even raised. That is why the rich have tended to
oppose juries as well as popular assemblies.

Unsurprisingly, the few individualist anarchists that remained pointed this
out. Laurance Labadie, the son of Tucker associate Joseph Labadie, argued in
response to Rothbard as follows:

> _"Mere common sense would suggest that any court would be influenced by
experience; and any free-market court or judge would in the very nature of
things have some precedents guiding them in their instructions to a jury. But
since no case is exactly the same, a jury would have considerable say about
the heinousness of the offence in each case, realising that circumstances
alter cases, and prescribing penalty accordingly. This appeared to Spooner and
Tucker to be a more flexible and equitable administration of justice possible
or feasible, human beings being what they are.. . . _

>

> _"But when Mr. Rothbard quibbles about the jurisprudential ideas of Spooner
and Tucker, and at the same time upholds **presumably in his courts** the very
economic evils which are at bottom the very reason for human contention and
conflict, he would seem to be a man who chokes at a gnat while swallowing a
camel."_ [quoted by Mildred J. Loomis and Mark A. Sullivan, _"Laurance
Labadie: Keeper Of The Flame"_, pp. 116-30, **Benjamin R. Tucker and the
Champions of Liberty**, Coughlin, Hamilton and Sullivan (eds.), p. 124]

In other words, to exclude the general population from any say in the law and
how it changes is hardly a _"minor"_ difference! Particularly if you are
proposing an economic system which is based on inequalities of wealth, power
and influence and the means of accumulating more. It is like a supporter of
the state saying that it is a _"minor"_ difference if you favour a
dictatorship rather than a democratically elected government. As Tucker
argued, _"it is precisely in the tempering of the rigidity of enforcement that
one of the chief excellences of Anarchism consists . . . under Anarchism all
rules and laws will be little more than suggestions for the guidance of
juries, and that all disputes . . . will be submitted to juries which will
judge not only the facts but the law, the justice of the law, its
applicability to the given circumstances, and the penalty or damage to be
inflicted because of its infraction . . . under Anarchism the law . . . will
be regarded as **just** in proportion to its flexibility, instead of now in
proportion to its rigidity."_ [**The Individualist Anarchists**, pp. 160-1] In
others, the law will evolve to take into account changing social circumstances
and, as a consequence, public opinion on specific events and rights. Tucker's
position is fundamentally **democratic** and evolutionary while Rothbard's is
autocratic and fossilised.

On the land question, Rothbard opposed the individualist position of
"occupancy and use" as it _"would automatically abolish all rent payments for
land."_ Which was **precisely** why the individualist anarchists advocated it!
In a predominantly rural economy, this would result in a significant levelling
of income and social power as well as bolstering the bargaining position of
non-land workers by reducing unemployment. He bemoans that landlords cannot
charge rent on their _"justly-acquired private property"_ without noticing
that is begging the question as anarchists deny that this is _"justly-
acquired"_ land. Unsurprising, Rothbard considers _"the property theory"_ of
land ownership as John Locke's, ignoring the fact that the first self-
proclaimed anarchist book was written to refute that kind of theory. His
argument simply shows how far from anarchism his ideology is. For Rothbard, it
goes without saying that the landlord's _"freedom of contract"_ tops the
worker's freedom to control their own work and live and, of course, their
right to life. [**Op. Cit.**, p. 8 and p. 9] However, for anarchists, _"the
land is indispensable to our existence, consequently a common thing,
consequently insusceptible of appropriation."_ [Proudhon, **What is
Property?**, p. 107]

The reason question is why Rothbard considers this a **political** difference
rather than an economic one. Unfortunately, he does not explain. Perhaps
because of the underlying **socialist** perspective behind the anarchist
position? Or perhaps the fact that feudalism and monarchism was based on the
owner of the land being its ruler suggests a political aspect to the ideology
best left unexplored? Given that the idea of grounding rulership on land
ownership receded during the Middle Ages, it may be unwise to note that under
"anarcho"-capitalism the landlord and capitalist would, likewise, be sovereign
over the land **and** those who used it? As we noted in [section
1](append131.md), this is the conclusion that Rothbard does draw. As such,
there **is** a political aspect to this difference.

Moreover. _"the expropriation of the mass of the people from the soil forms
the basis of the capitalist mode of production."_ [Marx, **Capital**, vol. 1,
p. 934] For there are _"two ways of oppressing men: either directly by brute
force, by physical violence; or indirectly by denying them the means of life
and this reducing them to a state of surrender."_ In the second case,
government is _"an organised instrument to ensure that dominion and privilege
will be in the hands of those who . . . have cornered all the means of life,
first and foremost the land, which they make use of to keep the people in
bondage and to make them work for their benefit."_ [Malatesta, **Anarchy**, p.
21] Privatising the coercive functions of said government hardly makes much
difference.

Of course, Rothbard is simply skimming the surface. There are two main ways
"anarcho"-capitalists differ from individualist anarchists. The first one is
the fact that the individualist anarchists are socialists. The second is on
whether equality is essential or not to anarchism. Each will be discussed in
turn.

Unlike both Individualist (and social) anarchists, "anarcho"-capitalists
support capitalism (a "pure" free market type, which has never existed
although it has been approximated occasionally). This means that they reject
totally the ideas of anarchists with regards to property and economic
analysis. For example, like all supporters of capitalists they consider rent,
profit and interest as valid incomes. In contrast, all Anarchists consider
these as exploitation and agree with the Individualist Anarchist Benjamin
Tucker when he argued that _"**[w]hoever** contributes to production is alone
entitled. **What** has no rights that **who** is bound to respect. **What** is
a thing. **Who** is a person. Things have no claims; they exist only to be
claimed. The possession of a right cannot be predicted of dead material, but
only a living person."_[quoted by Wm. Gary Kline, **The Individualist
Anarchists**, p. 73]

This, we must note, is the fundamental critique of the capitalist theory that
capital is productive. In and of themselves, fixed costs do not create value.
Rather value is creation depends on how investments are developed and used
once in place. Because of this the Individualist Anarchists, like other
anarchists, considered non-labour derived income as usury, unlike
"anarcho"-capitalists. Similarly, anarchists reject the notion of capitalist
property rights in favour of possession (including the full fruits of one's
labour). For example, anarchists reject private ownership of land in favour of
a "occupancy and use" regime. In this we follow Proudhon's **What is
Property?** and argue that _"property is theft"_. Rothbard, as noted, rejected
this perspective.

As these ideas are an **essential** part of anarchist politics, they cannot be
removed without seriously damaging the rest of the theory. This can be seen
from Tucker's comments that _"**Liberty** insists. . . [on] the abolition of
the State and the abolition of usury; on no more government of man by man, and
no more exploitation of man by man."_ [cited by Eunice Schuster in **Native
American Anarchism**, p. 140]. He indicates that anarchism has specific
economic **and** political ideas, that it opposes capitalism along with the
state. Therefore anarchism was never purely a "political" concept, but always
combined an opposition to oppression with an opposition to exploitation. The
social anarchists made exactly the same point. Which means that when Tucker
argued that _"**Liberty** insists on Socialism. . . - true Socialism,
Anarchistic Socialism: the prevalence on earth of Liberty, Equality, and
Solidarity"_ he knew exactly what he was saying and meant it wholeheartedly.
[**Instead of a Book**, p. 363]

So because "anarcho"-capitalists embrace capitalism and reject socialism, they
cannot be considered anarchists or part of the anarchist tradition.

Which brings us nicely to the second point, namely a lack of concern for
equality. In stark contrast to anarchists of all schools, inequality is not
seen to be a problem with "anarcho"-capitalists (see [section
3](append133.md)). However, it is a truism that not all "traders" are
equally subject to the market (i.e. have the same market power). In many
cases, a few have sufficient control of resources to influence or determine
price and in such cases, all others must submit to those terms or not buy the
commodity. When the commodity is labour power, even this option is lacking --
workers have to accept a job in order to live. As we argue in [section
10.2](append1310.md#secf102), workers are usually at a disadvantage on the
labour market when compared to capitalists, and this forces them to sell their
liberty in return for making profits for others. These profits increase
inequality in society as the property owners receive the surplus value their
workers produce. This increases inequality further, consolidating market power
and so weakens the bargaining position of workers further, ensuring that even
the freest competition possible could not eliminate class power and society
(something B. Tucker recognised as occurring with the development of trusts
within capitalism -- see [section G.4](secG4.md)).

By removing the underlying commitment to abolish non-labour income, any
"anarchist" capitalist society would have vast differences in wealth and so
power. Instead of a government imposed monopolies in land, money and so on,
the economic power flowing from private property and capital would ensure that
the majority remained in (to use Spooner's words) _"the condition of
servants"_ (see sections [2](append132.md) and [3.1](append133.md#secf31)
for more on this). The Individualist Anarchists were aware of this danger and
so supported economic ideas that opposed usury (i.e. rent, profit and
interest) and ensured the worker the full value of her labour. While not all
of them called these ideas "socialist" it is clear that these ideas **are**
socialist in nature and in aim (similarly, not all the Individualist
Anarchists called themselves anarchists but their ideas are clearly anarchist
in nature and in aim).

This combination of the political and economic is essential as they mutually
reinforce each other. Without the economic ideas, the political ideas would be
meaningless as inequality would make a mockery of them. As Kline notes, the
Individualist Anarchists' _"proposals were designed to establish true equality
of opportunity . . . and they expected this would result in a society without
great wealth or poverty. In the absence of monopolistic factors which would
distort competition, they expected a society largely of self-employed workmen
with no significant disparity of wealth between any of them since all would be
required to live at their own expense and not at the expense of exploited
fellow human beings."_ [**Op. Cit.**, pp. 103-4]

Because of the evil effects of inequality on freedom, both social and
individualist anarchists desired to create an environment in which
circumstances would not drive people to sell their liberty to others at a
disadvantage. In other words, they desired an equalisation of market power by
opposing interest, rent and profit and capitalist definitions of private
property. Kline summarises this by saying _"the American [individualist]
anarchists exposed the tension existing in liberal thought between private
property and the ideal of equal access. The Individual Anarchists were, at
least, aware that existing conditions were far from ideal, that the system
itself working against the majority of individuals in their efforts to attain
its promises. Lack of capital, the means to creation and accumulation of
wealth, usually doomed a labourer to a life of exploitation. This the
anarchists knew and they abhorred such a system."_ [**Op. Cit.**, p. 102]

And this desire for bargaining equality is reflected in their economic ideas
and by removing these underlying economic ideas of the individualist
anarchists, "anarcho"-capitalism makes a mockery of any ideas they do
appropriate. Essentially, the Individualist Anarchists agreed with Rousseau
that in order to prevent extreme inequality of fortunes you deprive people of
the means to accumulate in the first place and **not** take away wealth from
the rich. An important point which "anarcho"-capitalism fails to understand or
appreciate.

There are, of course, overlaps between individualist anarchism and
"anarcho"-capitalism, just as there are overlaps between it and Marxism (and
social anarchism, of course). However, just as a similar analysis of
capitalism does not make individualist anarchists Marxists, so apparent
similarities between individualist anarchism does not make it a forerunner of
"anarcho"-capitalism. For example, both schools support the idea of "free
markets." Yet the question of markets is fundamentally second to the issue of
property rights for what is exchanged on the market is dependent on what is
considered legitimate property. In this, as Rothbard notes, individualist
anarchists and "anarcho"-capitalists differ and different property rights
produce different market structures and dynamics. This means that capitalism
is not the only economy with markets and so support for markets cannot be
equated with support for capitalism. Equally, opposition to markets is **not**
the defining characteristic of socialism (as we note in [section
G.2.1](secG2.md#secg21)). As such, it **is** possible to be a market
socialist (and many socialist are). This is because "markets" and "property"
do not equate to capitalism:

> _"Political economy confuses, on principle, two very different kinds of
private property, one of which rests on the labour of the producers himself,
and the other on the exploitation of the labour of others. It forgets that the
latter is not only the direct antithesis of the former, but grows on the
former's tomb and nowhere else. _

>

> _"In Western Europe, the homeland of political economy, the process of
primitive accumulation is more of less accomplished. . . . _

>

> _"It is otherwise in the colonies. There the capitalist regime constantly
comes up against the obstacle presented by the producer, who, as owner of his
own conditions of labour, employs that labour to enrich himself instead of the
capitalist. The contradiction of these two diametrically opposed economic
systems has its practical manifestation here in the struggle between them."_
[Karl Marx, **Capital**, vol. 1, p. 931]

Individualist anarchism is obviously an aspect of this struggle between the
system of peasant and artisan production of early America and the state
encouraged system of private property and wage labour. "Anarcho"-capitalists,
in contrast, assume that generalised wage labour would remain under their
system (while paying lip-service to the possibilities of co-operatives -- and
if an "anarcho"-capitalist thinks that co-operative will become the dominant
form of workplace organisation, then they are some kind of market socialist,
**not** a capitalist). It is clear that their end point (a pure capitalism,
i.e. generalised wage labour) is directly the opposite of that desired by
anarchists. This was the case of the Individualist Anarchists who embraced the
ideal of (non-capitalist) laissez faire competition -- they did so, as noted,
to **end** exploitation, **not** to maintain it. Indeed, their analysis of the
change in American society from one of mainly independent producers into one
based mainly upon wage labour has many parallels with, of all people, Karl
Marx's presented in chapter 33 of **Capital**. Marx, correctly, argues that
_"the capitalist mode of production and accumulation, and therefore capitalist
private property, have for their fundamental condition the annihilation of
that private property which rests on the labour of the individual himself; in
other words, the expropriation of the worker."_ [**Op. Cit.**, p. 940] He
notes that to achieve this, the state is used:

> _"How then can the anti-capitalistic cancer of the colonies be healed? . . .
Let the Government set an artificial price on the virgin soil, a price
independent of the law of supply and demand, a price that compels the
immigrant to work a long time for wages before he can earn enough money to buy
land, and turn himself into an independent farmer."_ [**Op. Cit.**, p. 938]

Moreover, tariffs are introduced with _"the objective of manufacturing
capitalists artificially"_ for the _"system of protection was an artificial
means of manufacturing manufacturers, or expropriating independent workers, of
capitalising the national means of production and subsistence, and of forcibly
cutting short the transition . . . to the modern mode of production,"_ to
capitalism [**Op. Cit.**, p. 932 and pp. 921-2]

It is this process which Individualist Anarchism protested against, the use of
the state to favour the rising capitalist class. However, unlike social
anarchists, many individualist anarchists were not consistently against wage
labour. This is the other significant overlap between "anarcho"-capitalism and
individualist anarchism. However, they were opposed to exploitation and argued
(unlike "anarcho"-capitalism) that in their system workers bargaining powers
would be raised to such a level that their wages would equal the full product
of their labour. However, as we discuss in [section G.1.1](secG1.md#secg11)
the social context the individualist anarchists lived in must be remembered.
America at the times was a predominantly rural society and industry was not as
developed as it is now wage labour would have been minimised (Spooner, for
example, explicitly envisioned a society made up mostly entirely of self-
employed workers). As Kline argues:

> _"Committed as they were to equality in the pursuit of property, the
objective for the anarchist became the construction of a society providing
equal access to those things necessary for creating wealth. The goal of the
anarchists who extolled mutualism and the abolition of all monopolies was,
then, a society where everyone willing to work would have the tools and raw
materials necessary for production in a non-exploitative system . . . the
dominant vision of the future society . . . [was] underpinned by individual,
self-employed workers."_ [**Op. Cit.**, p. 95]

As such, a limited amount of wage labour within a predominantly self-employed
economy does not make a given society capitalist any more than a small amount
of governmental communities within an predominantly anarchist world would make
it statist. As Marx argued. when _"the separation of the worker from the
conditions of labour and from the soil . . . does not yet exist, or only
sporadically, or on too limited a scale . . . Where, amongst such curious
characters, is the 'field of abstinence' for the capitalists? . . . Today's
wage-labourer is tomorrow's independent peasant or artisan, working for
himself. He vanishes from the labour-market -- but not into the workhouse."_
There is a _"constant transformation of wage-labourers into independent
producers, who work for themselves instead of for capital"_ and so _"the
degree of exploitation of the wage-labourer remain[s] indecently low."_ In
addition, the _"wage-labourer also loses, along with the relation of
dependence, the feeling of dependence on the abstemious capitalist."_ [**Op.
Cit.**, pp. 935-6]

Saying that, as we discuss in [section G.4](secG4.md), individualist
anarchist support for wage labour is at odds with the ideas of Proudhon and,
far more importantly, in contradiction to many of the stated principles of the
individualist anarchists themselves. In particular, wage labour violates
"occupancy and use" as well as having more than a passing similarity to the
state. However, these problems can be solved by consistently applying the
principles of individualist anarchism, unlike "anarcho"-capitalism, and that
is why it is a real school of anarchism. In other words, a system of
**generalised** wage labour would not be anarchist nor would it be non-
exploitative. Moreover, the social context these ideas were developed in and
would have been applied ensure that these contradictions would have been
minimised. If they had been applied, a genuine anarchist society of self-
employed workers would, in all likelihood, have been created (at least at
first, whether the market would increase inequalities is a moot point -- see
[section G.4](secG4.md)).

We must stress that the social situation is important as it shows how
apparently superficially similar arguments can have radically different aims
and results depending on who suggests them and in what circumstances. As
noted, during the rise of capitalism the bourgeoisie were not shy in urging
state intervention against the masses. Unsurprisingly, working class people
generally took an anti-state position during this period. The individualist
anarchists were part of that tradition, opposing what Marx termed _"primitive
accumulation"_ in favour of the pre-capitalist forms of property and society
it was destroying.

However, when capitalism found its feet and could do without such obvious
intervention, the possibility of an "anti-state" capitalism could arise. Such
a possibility became a definite once the state started to intervene in ways
which, while benefiting the system as a whole, came into conflict with the
property and power of individual members of the capitalist and landlord class.
Thus social legislation which attempted to restrict the negative effects of
unbridled exploitation and oppression on workers and the environment were
having on the economy were the source of much outrage in certain bourgeois
circles:

> _"Quite independently of these tendencies [of individualist anarchism] . . .
the anti-state bourgeoisie (which is also anti-statist, being hostile to any
social intervention on the part of the State to protect the victims of
exploitation -- in the matter of working hours, hygienic working conditions
and so on), and the greed of unlimited exploitation, had stirred up in England
a certain agitation in favour of pseudo-individualism, an unrestrained
exploitation. To this end, they enlisted the services of a mercenary pseudo-
literature . . . which played with doctrinaire and fanatical ideas in order to
project a species of 'individualism' that was absolutely sterile, and a
species of 'non-interventionism' that would let a man die of hunger rather
than offend his dignity."_ [Max Nettlau, **A Short History of Anarchism**, p.
39]

This perspective can be seen when Tucker denounced Herbert Spencer as a
champion of the capitalistic class for his vocal attacks on social legislation
which claimed to benefit working class people but stays strangely silent on
the laws passed to benefit (usually indirectly) capital and the rich.
"Anarcho"-capitalism is part of that tradition, the tradition associated with
a capitalism which no longer needs obvious state intervention as enough wealth
as been accumulated to keep workers under control by means of market power.

As with the original nineteenth century British "anti-state" capitalists like
Spencer and Herbert, Rothbard _"completely overlooks the role of the state in
building and maintaining a capitalist economy in the West. Privileged to live
in the twentieth century, long after the battles to establish capitalism have
been fought and won, Rothbard sees the state solely as a burden on the market
and a vehicle for imposing the still greater burden of socialism. He manifests
a kind of historical nearsightedness that allows him to collapse many
centuries of human experience into one long night of tyranny that ended only
with the invention of the free market and its 'spontaneous' triumph over the
past. It is pointless to argue, as Rothbard seems ready to do, that capitalism
would have succeeded without the bourgeois state; the fact is that all
capitalist nations have relied on the machinery of government to create and
preserve the political and legal environments required by their economic
system."_ That, of course, has not stopped him _"critis[ing] others for being
unhistorical."_ [Stephen L Newman, **Liberalism at Wit's End**, pp. 77-8 and
p. 79]

In other words, there is substantial differences between the victims of a
thief trying to stop being robbed and be left alone to enjoy their property
and the successful thief doing the same! Individualist Anarchist's were aware
of this. For example, Victor Yarros stressed this key difference between
individualist anarchism and the proto-"libertarian" capitalists of
"voluntaryism":

> _"[Auberon Herbert] believes in allowing people to retain all their
possessions, no matter how unjustly and basely acquired, while getting them,
so to speak, to swear off stealing and usurping and to promise to behave well
in the future. We, on the other hand, while insisting on the principle of
private property, in wealth honestly obtained under the reign of liberty, do
not think it either unjust or unwise to dispossess the landlords who have
monopolised natural wealth by force and fraud. We hold that the poor and
disinherited toilers would be justified in expropriating, not alone the
landlords, who notoriously have no equitable titles to their lands, but
**all** the financial lords and rulers, all the millionaires and very wealthy
individuals. . . . Almost all possessors of great wealth enjoy neither what
they nor their ancestors rightfully acquired (and if Mr. Herbert wishes to
challenge the correctness of this statement, we are ready to go with him into
a full discussion of the subject). . . . _

>

> _"If he holds that the landlords are justly entitled to their lands, let him
make a defence of the landlords or an attack on our unjust proposal."_ [quoted
by Carl Watner, _"The English Individualists As They Appear In Liberty,"_ pp.
191-211, **Benjamin R. Tucker and the Champions of Liberty**, Coughlin,
Hamilton and Sullivan (eds.), pp. 199-200]

Significantly, Tucker and other individualist anarchists saw state
intervention has a result of capital manipulating legislation to gain an
advantage on the so-called free market which allowed them to exploit labour
and, as such, it benefited the **whole** capitalist class. Rothbard, at best,
acknowledges that **some** sections of big business benefit from the current
system and so fails to have the comprehensive understanding of the dynamics of
capitalism as a **system** (rather as an ideology). This lack of understanding
of capitalism as a historic and dynamic system rooted in class rule and
economic power is important in evaluating "anarcho"-capitalist claims to
anarchism. Marxists are not considered anarchists as they support the state as
a means of transition to an anarchist society. Much the same logic can be
applied to right-wing libertarians (even if they do call themselves
"anarcho"-capitalists). This is because they do not seek to correct the
inequalities produced by previous state action before ending it nor do they
seek to change the definitions of "private property" imposed by the state. In
effect, they argue that the "dictatorship of the bourgeoisie" should "wither
away" and be limited to defending the property accumulated in a few hands.
Needless to say, starting from the current (coercively produced) distribution
of property and then eliminating "force" simply means defending the power and
privilege of ruling minorities:

> _"The modern Individualism initiated by Herbert Spencer is, like the
critical theory of Proudhon, a powerful indictment against the dangers and
wrongs of government, but its practical solution of the social problem is
miserable -- so miserable as to lead us to inquire if the talk of 'No force'
be merely an excuse for supporting landlord and capitalist domination."_
[**Act For Yourselves**, p. 98]

[‹ 0 Introduction](append13int.md "Go to previous page" ) [up](append13.md
"Go to parent page" ) [2 What do "anarcho"-capitalists mean by "freedom"?
›](append132.md "Go to next page" )

