!{\src2tex{textfont=tt}}
!!****f* ABINIT/surot
!! NAME
!! surot
!!
!! FUNCTION
!! Set up tables indicating rotations of r-points and G-vectors
!! IROTTB(r,R) contains the index no. of R**-1 r in the FFT grid [Note inverse!]
!! GROTTB(G,I,R) contains the index no. of R I G
!! GROTTBM1(G,I,R) contains the index no. of R**-1 I G
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MT, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  gvec(3,npwvec)=coordinates of plane waves
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  ninv=if 2, inversion is considered; if 1, inversion is not considered
!!  nop=number of symmetry operations
!!  npwvec=number of planewaves
!!  nr=number of points of FFT grid
!!  op(3,3,nop)=symmetry operations in reciprocal space
!!
!! OUTPUT
!!  grottb(npwvec,2,nop)= contains the index of (IR) G where I is the identity or the inversion 
!!   operation and G is one of the npwvec vectors in reciprocal space 
!!  grottbm1(npwvec,2,nop)=  contains the index  (IR)**-1 G 
!!  irottb(nr,nop)= contains the index in the FFT array of (R**-1) r, where R is
!!   one of the nop symmetry operations in reciprocal space 
!!
!! PARENTS
!!      mrgscr,screening,sigma
!!
!! CHILDREN
!!      dosym,dosymr
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine surot(op,nop,ninv,ngfft1,ngfft1a,ngfft2,ngfft3,nr,npwvec,gvec,grottb,&
& irottb,grottbm1)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => surot
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngfft1,ngfft1a,ngfft2,ngfft3,ninv,nop,npwvec,nr
 character(len=500) :: message
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 integer,intent(out) :: grottb(npwvec,2,nop),grottbm1(npwvec,2,nop)
 integer,intent(out) :: irottb(nr,nop)
 real(dp),intent(in) :: op(3,3,nop)

!Local variables ------------------------------
!scalars
 integer :: ifound,ig,igp,iinv,iop,ir,ix,iy,iz,jx,jy,jz
!arrays
 integer :: ngfft(3)
 real(dp) :: gx(3),gxx(3),r(3),rrot(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: modx
#endif
!End of the abilint section

 write(message,'(a)')' setting up r- and G-rotation tables'
 call wrtout(6,message,'COLL')

 ngfft(1)=ngfft1
 ngfft(2)=ngfft2
 ngfft(3)=ngfft3

 do ix=0,ngfft1-1
  do iy=0,ngfft2-1
   do iz=0,ngfft3-1
    r(1)=ix
    r(2)=iy
    r(3)=iz
    ir=1+ix+iy*ngfft1a+iz*ngfft1a*ngfft2
    do iop=1,nop
     !Form R**-1 r
     call dosymr (op(1,1,iop),1,r,ngfft,rrot)
     jx=modx(nint(rrot(1)),ngfft1)
     jy=modx(nint(rrot(2)),ngfft2)
     jz=modx(nint(rrot(3)),ngfft3)
     irottb(ir,iop)=1+jx+jy*ngfft1a+jz*ngfft1a*ngfft2
    end do 
   end do 
  end do 
 end do

!Ensure that any spare space in the FFT array (because of
!NFFT1A possible being one greater than NFFT1) is always
!rotated onto itself so that no harm is done.  Note that the
!do-loop is not executed if NFFT1A=NFFT1
 do ix=ngfft1,ngfft1a-1
  do iy=0,ngfft2-1
   do iz=0,ngfft3-1
    ir=1+ix+iy*ngfft1a+iz*ngfft1a*ngfft2
    do iop=1,nop
     irottb(ir,iop)=ir
    end do 
   end do 
  end do 
 end do 

 write(message,'(a)')' r-rotation tables set up'
 call wrtout(6,message,'COLL')

!Set up G-rotation table
 do ig=1,npwvec
  gx(1)=gvec(1,ig)
  gx(2)=gvec(2,ig)
  gx(3)=gvec(3,ig)
  do iinv=1,ninv
   do iop=1,nop
    call dosym(op(1,1,iop),iinv,gx,gxx)
    ifound=0
    do igp=1,npwvec
     if(abs(gxx(1)-gvec(1,igp))<1.0e-3) then
      if(abs(gxx(2)-gvec(2,igp))<1.0e-3) then
       if(abs(gxx(3)-gvec(3,igp))<1.0e-3) then
        ifound=1
        grottb(ig,iinv,iop)=igp
        grottbm1(igp,iinv,iop)=ig
       end if
      end if
     end if
    end do 
    if(ifound==0) then
     write(message,'(3a)')&
&     ' surot: ERROR-',ch10,&
&     ' g-shell not closed'
     call wrtout(6,message,'COLL')
     write(*,*) ig,npwvec,iop,iinv,gxx,gx
     !write(*,*) ((gvec(i,j),i=1,3),j=1,npwvec)
     call leave_new('COLL')
    end if
   end do 
  end do 
 end do 

 write (message,'(2a)')' G-rotation tables set up',ch10
 call wrtout(6,message,'COLL')

 end subroutine surot
!!***
